% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{get_dots}
\alias{get_dots}
\alias{missing_dots}
\title{Get or check elements from dots \code{'...'}}
\usage{
get_dots(..name, ..default = NULL, ...)

missing_dots(envir = parent.frame())
}
\arguments{
\item{..name}{character name of the argument}

\item{..default}{R object to return if argument not found}

\item{...}{dots that contains argument}

\item{envir}{R environment}
}
\value{
\code{missing_dots} returns logical vector with lengths matching
with dot lengths. \code{get_dots} returns value corresponding to the name.
}
\description{
Get information from \code{'...'} without
evaluating the arguments.
}
\examples{


# ------------------------ Basic Usage ---------------------------

# missing_dots(environment()) is a fixed usage

my_function <- function(...){
  missing_dots(environment())
}
my_function(,)

# get_dots
plot2 <- function(...){
  title = get_dots('main', 'There is no title', ...)
  plot(...)
  title
}

plot2(1:10)
plot2(1:10, main = 'Scatter Plot of 1:10')

# ------------------------ Comparisons ----------------------------
f1 <- function(...){ get_dots('x', ...) }
f2 <- function(...){ list(...)[['x']] }
delayedAssign('y', { cat('y is evaluated!') })

# y will not evaluate
f1(x = 1, y = y)

# y gets evaluated
f2(x = 1, y = y)

# -------------------- Decorator example --------------------------
ret_range <- function(which_range = 'y'){
  function(f){
    function(...){
      f(...)
      y_range <- range(get_dots(which_range, 0, ...))
      y_range
    }
  }
}
plot_ret_yrange <- plot \%D\% ret_range('y')
plot_ret_yrange(x = 1:10, y = rnorm(10))


}
