## Quick overview

This tools allows you to interactively explore, analyze, and visualize droplet digital PCR (ddPCR) data.

Select the **<i class="fa fa-table"></i> Dataset** tab to load ddPCR data.

Select the **<i class="fa fa-cog"></i> Settings** tab to modify parameters of a ddPCR data after it has been loaded.

Select the **<i class="fa fa-calculator"></i> Analyze** tab to run automated analysis on the loaded ddPCR data.

Select the **<i class="fa fa-bar-chart"></i> Results** tab to visualize the results of the analysis using tables and figures.

At any point after initially loading a dataset, you may download the data in its current state (**<i class="fa fa-download"></i> Save data** button) and load it again in the future.

Whenever a new dataset is loaded or the settings of an existing dataset are changed, you should re-analyze the data.

## More information

This tool is part of a package developed in the R programming language. For more information, <a target="_blank" href="https://github.com/daattali/ddpcr#readme" >see the complete README</a>.

A peer-reviewed publication describing this tool is available in <a target="_blank" href="https://f1000research.com/articles/5-1411">F1000Research</a>.

The methods were originally developed for a paper <a target="_blank" href="https://www.jmdjournal.org/article/S1525-1578(15)00262-7/fulltext">"Quantitative Detection and Resolution of BRAF V600 Status in Colorectal Cancer Using Droplet Digital PCR and a Novel Wild-Type Negative Assay"</a> by Roza Bidshahri, Dean Attali, et al. The sample data is also from the same project. 

## License

This software was developed by <a target="_blank" href="https://deanattali.com" >Dean Attali</a> and is available freely under the MIT license. The source code is available <a target="_blank" href="https://github.com/daattali/ddpcr">on GitHub</a>.  
For any comments or questions, please <a target="_blank" href="https://deanattali.com/contact">contact Dean</a>.
