% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_apriori.R
\name{pat_apriori}
\alias{pat_apriori}
\title{Apriori rules}
\usage{
pat_apriori(
  parameter = list(supp = 0.5, conf = 0.9, minlen = 2, maxlen = 10, target = "rules"),
  appearance = NULL,
  control = NULL
)
}
\arguments{
\item{parameter}{list of parameters passed to \code{arules::apriori}}

\item{appearance}{list of item appearance constraints}

\item{control}{list of control parameters}
}
\value{
returns a \code{pat_apriori} object
}
\description{
Frequent itemsets and association rules using \code{arules::apriori}.
}
\examples{
data("AdultUCI", package = "arules")
trans <- suppressWarnings(methods::as(as.data.frame(AdultUCI), "transactions"))
pm <- pat_apriori(parameter = list(
 supp = 0.5, conf = 0.9, minlen = 2, maxlen = 10, target = "rules"
))
pm <- fit(pm, trans)
rules <- discover(pm)
arules::inspect(rules)
}
