% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plan.R
\name{model_signature}
\alias{model_signature}
\title{Internal: compute a model cache key for an instance}
\usage{
model_signature(inst_key, eval_token, methods, plan, K)
}
\arguments{
\item{inst_key}{Instance key (character) in \code{plan$instances}.}

\item{eval_token}{An evaluation token created by
\code{make_eval_token()}.}

\item{methods}{The methods list used to build \code{plan}.}

\item{plan}{The cross-fitting plan as returned by
\code{\link{build_instances}}.}

\item{K}{Number of folds.}
}
\value{
A character string uniquely identifying the model for this
instance and training-fold configuration.
}
\description{
Computes a unique model signature for a given instance under a given
evaluation token. The signature combines:
\itemize{
\item the instance's structural signature (\code{inst$struct_sig}),
\item the set of training folds used for this eval panel.
}
}
\details{
This is used as a key in the model cache so that models are reused
exactly when both structure and training data coincide.
}
\keyword{internal}
