% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lap_solve_kbest.R
\name{lap_solve_kbest}
\alias{lap_solve_kbest}
\title{Find k-best optimal assignments}
\usage{
lap_solve_kbest(
  x,
  k = 3,
  source = NULL,
  target = NULL,
  cost = NULL,
  maximize = FALSE,
  method = "murty",
  single_method = "jv",
  forbidden = NA
)
}
\arguments{
\item{x}{Cost matrix, data frame, or tibble. If a data frame/tibble,
must include columns specified by \code{source}, \code{target}, and \code{cost}.}

\item{k}{Number of best solutions to return (default: 3)}

\item{source}{Column name for source/row indices (if \code{x} is a data frame)}

\item{target}{Column name for target/column indices (if \code{x} is a data frame)}

\item{cost}{Column name for costs (if \code{x} is a data frame)}

\item{maximize}{Logical; if TRUE, finds k-best maximizing assignments (default: FALSE)}

\item{method}{Algorithm for each sub-problem (default: "murty"). Future versions
may support additional methods.}

\item{single_method}{Algorithm used for solving each node in the search tree
(default: "jv")}

\item{forbidden}{Value to mark forbidden assignments (default: NA)}
}
\value{
A tibble with columns:
\itemize{
\item \code{rank}: ranking of solutions (1 = best, 2 = second best, etc.)
\item \code{solution_id}: unique identifier for each solution
\item \code{source}: source indices
\item \code{target}: target indices
\item \code{cost}: cost of each edge in the assignment
\item \code{total_cost}: total cost of the complete solution
}
}
\description{
Returns the top k optimal (or near-optimal) assignments using 'Murty' algorithm.
Useful for exploring alternative optimal solutions or finding robust assignments.
}
\examples{
# Matrix input - find 5 best solutions
cost <- matrix(c(4, 2, 5, 3, 3, 6, 7, 5, 4), nrow = 3)
lap_solve_kbest(cost, k = 5)

# Data frame input
library(dplyr)
df <- tibble(
  source = rep(1:3, each = 3),
  target = rep(1:3, times = 3),
  cost = c(4, 2, 5, 3, 3, 6, 7, 5, 4)
)
lap_solve_kbest(df, k = 3, source, target, cost)

# With maximization
lap_solve_kbest(cost, k = 3, maximize = TRUE)

}
