% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/couplr-package.R
\docType{package}
\name{couplr-package}
\alias{couplr-package}
\alias{couplr}
\title{couplr: Optimal Pairing and Matching via Linear Assignment}
\description{
Solves optimal pairing and matching problems using linear assignment algorithms. Provides implementations of the Hungarian method (Kuhn 1955) \doi{10.1002/nav.3800020109}, Jonker-Volgenant shortest path algorithm (Jonker and Volgenant 1987) \doi{10.1007/BF02278710}, Auction algorithm (Bertsekas 1988) \doi{10.1007/BF02186476}, cost-scaling (Goldberg and Kennedy 1995) \doi{10.1007/BF01585996}, scaling algorithms (Gabow and Tarjan 1989) \doi{10.1137/0218069}, push-relabel (Goldberg and Tarjan 1988) \doi{10.1145/48014.61051}, and Sinkhorn entropy-regularized transport (Cuturi 2013) \doi{10.48550/arxiv.1306.0895}. Designed for matching plots, sites, samples, or any pairwise optimization problem. Supports rectangular matrices, forbidden assignments, data frame inputs, batch solving, k-best solutions, and pixel-level image morphing for visualization. Includes automatic preprocessing with variable health checks, multiple scaling methods (standardized, range, robust), greedy matching algorithms, and comprehensive balance diagnostics for assessing match quality using standardized differences and distribution comparisons.

Solves optimal pairing and matching problems using linear assignment algorithms.
Designed for matching plots, sites, samples, or any pairwise optimization problem.
Provides modern, tidy implementations of 'Hungarian', 'Jonker-Volgenant', 'Auction',
and other LAP solvers.
}
\section{Main functions}{

\itemize{
\item{\code{\link{lap_solve}}}: Solve single assignment problems
\item{\code{\link{lap_solve_batch}}}: Solve multiple problems efficiently
\item{\code{\link{lap_solve_kbest}}}: Find k-best optimal solutions
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://gillescolling.com/couplr/}
  \item \url{https://github.com/gcol33/couplr}
  \item Report bugs at \url{https://github.com/gcol33/couplr/issues}
}

}
\author{
\strong{Maintainer}: Gilles Colling \email{gilles.colling051@gmail.com} (\href{https://orcid.org/0000-0003-3070-6066}{ORCID}) [copyright holder]

}
\keyword{internal}
