% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_cardinality.R
\name{cardinality_match}
\alias{cardinality_match}
\title{Cardinality Matching}
\usage{
cardinality_match(
  left,
  right,
  vars,
  max_std_diff = 0.1,
  distance = "euclidean",
  weights = NULL,
  scale = FALSE,
  auto_scale = FALSE,
  method = "auto",
  max_iter = 100L,
  batch_fraction = 0.1
)
}
\arguments{
\item{left}{Data frame of "left" units}

\item{right}{Data frame of "right" units}

\item{vars}{Character vector of matching variable names}

\item{max_std_diff}{Maximum allowed absolute standardized difference
(default: 0.1, corresponding to "excellent" balance)}

\item{distance}{Distance metric (default: "euclidean")}

\item{weights}{Optional named vector of variable weights}

\item{scale}{Scaling method (default: FALSE)}

\item{auto_scale}{If TRUE, automatically select scaling (default: FALSE)}

\item{method}{LAP solver method (default: "auto")}

\item{max_iter}{Maximum pruning iterations (default: 100)}

\item{batch_fraction}{Fraction of worst pairs to remove per iteration
(default: 0.1). Larger values speed up convergence but may over-prune.}
}
\value{
A matching_result object with additional cardinality info:
\code{result$info$pruning_iterations}, \code{result$info$pairs_removed},
\code{result$info$final_balance}.
}
\description{
Maximizes the number of matched pairs subject to balance constraints.
Uses iterative pruning: starts with a full match, then removes pairs
that contribute most to imbalance until all variables satisfy the
standardized difference threshold.
}
\details{
Cardinality matching (Zubizarreta 2014) finds the largest matched sample
that satisfies pre-specified balance constraints. This implementation uses
an iterative pruning heuristic:
\enumerate{
\item Run full optimal matching via \code{\link[=match_couples]{match_couples()}}
\item Compute balance diagnostics
\item While any |std_diff| exceeds \code{max_std_diff}:
\itemize{
\item Identify the variable with worst balance
\item Remove the batch of pairs contributing most to that imbalance
\item Recompute balance
}
}
}
\examples{
set.seed(42)
left <- data.frame(id = 1:20, x = rnorm(20, 0, 1), y = rnorm(20, 0, 1))
right <- data.frame(id = 21:50, x = rnorm(30, 0.5, 1), y = rnorm(30, 0.3, 1))
result <- cardinality_match(left, right, vars = c("x", "y"), max_std_diff = 0.2)
print(result)

}
