% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_plots.R
\name{autoplot.matching_result}
\alias{autoplot.matching_result}
\title{ggplot2 autoplot for matching results}
\usage{
\method{autoplot}{matching_result}(object, type = c("histogram", "density", "ecdf"), ...)
}
\arguments{
\item{object}{A matching_result object}

\item{type}{Type of plot: "histogram" (default), "density", or "ecdf"}

\item{...}{Additional arguments (ignored)}
}
\value{
A ggplot object
}
\description{
Produces ggplot2-based visualizations of matching distance distributions.
Returns a ggplot object that can be further customized.
}
\details{
Use \code{plot()} for base graphics or \code{autoplot()} for ggplot2 output.
The ggplot2 package must be installed.
}
\examples{
\donttest{
if (requireNamespace("ggplot2", quietly = TRUE)) {
  left <- data.frame(id = 1:5, x = c(1, 2, 3, 4, 5))
  right <- data.frame(id = 6:10, x = c(1.1, 2.2, 3.1, 4.2, 5.1))
  result <- match_couples(left, right, vars = "x")
  ggplot2::autoplot(result)
  ggplot2::autoplot(result, type = "density")
}
}

}
