% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle.R
\name{logLik}
\alias{logLik}
\title{Log-Likelihood}
\usage{
logLik(v, y, ni, S, invSigma, lr = c("alr", "clr"))
}
\arguments{
\item{v}{The additive or centered log-ratio transform of y}

\item{y}{Compositional dataset}

\item{ni}{The row sums of y}

\item{S}{Covariance of \code{v}}

\item{invSigma}{The inverse of the Sigma matrix}

\item{lr}{Which log-ratio transformation to use}
}
\value{
The estimated log-likelihood under the Multinomial logit-Normal distribution.
}
\description{
Calculates the log-likelihood, under the multinomial logit-Normal model.
}
\examples{
data(singlecell)
mle.sim <- mlePath(singlecell, tol=1e-4, tol.nr=1e-4, n.lambda = 2, n.cores = 1)

n <- NROW(singlecell)


logLik(mle.sim$est.min$v,
      singlecell,
      n,
      cov(mle.sim$est.min$v),
      mle.sim$est.min$Sigma.inv)

}
