% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnd_locations.R
\name{rnd_locations}
\alias{rnd_locations}
\title{Random location drawing}
\usage{
rnd_locations(
  nobs,
  xmin = -180,
  xmax = 180,
  ymin = -90,
  ymax = 90,
  output_type = c("data.table", "data.frame", "sf")
)
}
\arguments{
\item{nobs}{number of observations}

\item{xmin}{minimum longitude}

\item{xmax}{maximum longitude}

\item{ymin}{minimum latitude}

\item{ymax}{maximum latitude}

\item{output_type}{type of output object. Either \code{"data.table"} (default), \code{"data.frame"}, or \code{"sf"}.}
}
\value{
Returns a data.table, data.frame, or sf object of unprojected (longlat) points.
}
\description{
This function draws random locations in longlat format.
}
\details{
By default, this function draws a global sample of random locations. You can restrict it to a certain region via specifying \code{xmin}, \code{xmax}, \code{ymin},
and \code{ymax}. The function draws from a uniform spatial distribution that assumes the planet to be a perfect sphere. The spherical assumption is common in GIS
functions, but deviates from Earth's exact shape.
}
\examples{
data <- rnd_locations(1000)

}
