% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/problem.R
\name{clear_cache}
\alias{clear_cache}
\title{Clear derivative cache}
\usage{
clear_cache(problem)
}
\arguments{
\item{problem}{An mle_problem object}
}
\value{
The problem object (invisibly), modified in place
}
\description{
Clears the cached numerical derivatives (score and Fisher) from an mle_problem.
This is useful when you want to force recomputation, for example after
modifying data that the log-likelihood depends on.
}
\examples{
\donttest{
loglike <- function(theta) -sum((theta - c(1, 2))^2)
problem <- mle_problem(loglike, cache_derivatives = TRUE)
# ... run some optimization ...
clear_cache(problem)  # Force fresh derivative computation
}
}
