% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-network.R
\name{set_nodes}
\alias{set_nodes}
\title{Set Nodes in Cograph Network}
\usage{
set_nodes(x, nodes_df)
}
\arguments{
\item{x}{A cograph_network object.}

\item{nodes_df}{A data frame with node information (id, label columns expected).}
}
\value{
The modified cograph_network object.
}
\description{
Replaces the nodes data frame in a cograph_network object.
Automatically updates n_nodes and labels.
}
\examples{
mat <- matrix(c(0, 1, 1, 1, 0, 1, 1, 1, 0), nrow = 3)
net <- as_cograph(mat)
new_nodes <- data.frame(id = 1:3, label = c("A", "B", "C"))
net <- set_nodes(net, new_nodes)
get_labels(net)
}
\seealso{
\code{\link{as_cograph}}, \code{\link{get_nodes}}, \code{\link{set_edges}}
}
