% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splot-labels.R
\name{format_edge_label_template}
\alias{format_edge_label_template}
\title{Format Edge Label from Template}
\usage{
format_edge_label_template(
  template,
  weight = NA,
  ci_lower = NA,
  ci_upper = NA,
  p_value = NA,
  stars = "",
  digits = 2,
  p_digits = 3,
  p_prefix = "p=",
  ci_format = "bracket",
  oneline = TRUE
)
}
\arguments{
\item{template}{Template string with placeholders: \{est\}, \{range\}, \{low\}, \{up\}, \{p\}, \{stars\}.}

\item{weight}{Edge weight (estimate).}

\item{ci_lower}{Lower CI bound.}

\item{ci_upper}{Upper CI bound.}

\item{p_value}{P-value.}

\item{stars}{Significance stars string.}

\item{digits}{Decimal places for estimates.}

\item{p_digits}{Decimal places for p-values.}

\item{p_prefix}{Prefix for p-values.}

\item{ci_format}{CI format: "bracket" or "dash".}

\item{oneline}{Logical: single line format (space-separated) or multiline.}
}
\value{
Formatted label string.
}
\description{
Processes a template string with placeholders and substitutes values.
}
\keyword{internal}
