% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splot-nodes.R
\name{draw_donut_node_base}
\alias{draw_donut_node_base}
\title{Draw Donut Chart Node}
\usage{
draw_donut_node_base(
  x,
  y,
  size,
  values,
  colors = NULL,
  default_color = NULL,
  inner_ratio = 0.5,
  bg_color = "gray90",
  center_color = "white",
  border.col = "black",
  border.width = 1,
  donut_border.width = NULL,
  outer_border.col = NULL,
  border.lty = 1,
  show_value = TRUE,
  value_cex = 0.8,
  value_col = "black",
  value_fontface = "bold",
  value_fontfamily = "sans",
  value_digits = 2,
  value_prefix = "",
  value_suffix = ""
)
}
\arguments{
\item{x, y}{Node center coordinates.}

\item{size}{Outer radius.}

\item{values}{Single numeric value (0-1) specifying fill proportion.
0.1 = 10\% filled arc, 0.5 = 50\% filled, 1.0 = full ring.}

\item{colors}{Fill color for the donut ring.}

\item{default_color}{Fallback color when colors is NULL.}

\item{inner_ratio}{Ratio of inner to outer radius (0-1). Default 0.5.}

\item{bg_color}{Background color for unfilled portion. Default "gray90".}

\item{border.col}{Border color.}

\item{border.width}{Border line width.}

\item{donut_border.width}{Border width for donut ring (NULL = use border.width).}

\item{show_value}{Logical: show value in center? Default FALSE.}

\item{value_cex}{Text size for center value.}

\item{value_col}{Text color for center value.}

\item{value_fontface}{Font face for center value ("plain", "bold", "italic", "bold.italic").}

\item{value_fontfamily}{Font family for center value ("sans", "serif", "mono").}

\item{value_digits}{Decimal places for value display.}

\item{value_prefix}{Text before value (e.g., "$").}

\item{value_suffix}{Text after value (e.g., "\%").}
}
\description{
Renders a node as a donut chart with an inner hole.
The donut shows a fill proportion (0-1) as an arc starting from 12 o'clock.
}
\keyword{internal}
