% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splot-edges.R
\name{draw_curved_edge_base}
\alias{draw_curved_edge_base}
\title{Draw Curved Edge with xspline (qgraph-style)}
\usage{
draw_curved_edge_base(
  x1,
  y1,
  x2,
  y2,
  curve = 0.2,
  curvePivot = 0.5,
  col = "gray50",
  lwd = 1,
  lty = 1,
  arrow = TRUE,
  asize = 0.02,
  bidirectional = FALSE,
  start_lty = 1,
  start_fraction = 0,
  arrow_angle = pi/6
)
}
\arguments{
\item{x1, y1}{Start point coordinates.}

\item{x2, y2}{End point coordinates.}

\item{curve}{Curvature amount (positive = clockwise, negative = counterclockwise
when looking from source to target).}

\item{curvePivot}{Position along edge for control point (0-1).}

\item{col}{Edge color.}

\item{lwd}{Line width.}

\item{lty}{Line type.}

\item{arrow}{Logical: draw arrow at target?}

\item{asize}{Arrow size.}

\item{bidirectional}{Logical: draw arrow at source too?}

\item{start_lty}{Line type for start segment. 1=solid (default), 2=dashed, 3=dotted.}

\item{start_fraction}{Fraction of edge length for start segment (0-0.5). Default 0.}

\item{arrow_angle}{Arrow head angle in radians. Default pi/6 (30 degrees).}
}
\description{
Renders a curved edge using xspline() with optional arrow.
Uses qgraph-style curve calculation for smooth, natural-looking curves.
Curve direction is normalized so positive curve always bends the same
visual direction regardless of edge orientation.
}
\keyword{internal}
