% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnefe_counts.R
\name{cnefe_counts}
\alias{cnefe_counts}
\title{Count CNEFE address species on a spatial grid}
\usage{
cnefe_counts(
  code_muni,
  year = 2022,
  polygon_type = c("hex", "user"),
  polygon = NULL,
  crs_output = NULL,
  h3_resolution = 9,
  verbose = TRUE,
  backend = c("duckdb", "r")
)
}
\arguments{
\item{code_muni}{Integer. Seven-digit IBGE municipality code.}

\item{year}{Integer. The CNEFE data year. Currently only 2022 is supported.
Defaults to 2022.}

\item{polygon_type}{Character. Type of polygon aggregation: \code{"hex"} (default)
uses an H3 hexagonal grid; \code{"user"} uses polygons provided via the \code{polygon}
parameter.}

\item{polygon}{An \code{\link[sf:sf]{sf::sf}} object with polygon geometries. Required when
\code{polygon_type = "user"}. A warning is issued reporting the percentage of
CNEFE points covered by the polygon area. If no CNEFE points fall within
the polygon, an error is raised.}

\item{crs_output}{The CRS for the output object. Only used when
\code{polygon_type = "user"}. Default is \code{NULL}, which uses the original CRS of
the \code{polygon} argument. Can be an EPSG code (e.g., 4326, 31983) or any CRS
object accepted by \code{\link[sf:st_transform]{sf::st_transform()}}.}

\item{h3_resolution}{Integer. H3 grid resolution (default: 9). Only used when
\code{polygon_type = "hex"}.}

\item{verbose}{Logical; if \code{TRUE}, prints messages and timing information.}

\item{backend}{Character. \code{"duckdb"} (default) uses DuckDB with H3/spatial
extensions. \code{"r"} uses h3jsr and sf in R (slower but no DuckDB dependency).}
}
\value{
An \code{\link[sf:sf]{sf::sf}} object containing:
\itemize{
\item \code{id_hex} (when \code{polygon_type = "hex"}): H3 cell identifier
\item Original columns from \code{polygon} (when \code{polygon_type = "user"})
\item \code{addr_type1} ... \code{addr_type8}: counts per address type
\item \code{geometry}: polygon geometry
}

When \code{polygon_type = "user"}, the output CRS matches the original \code{polygon} CRS
(or \code{crs_output} if specified).
}
\description{
\code{cnefe_counts()} reads CNEFE records for a given municipality, assigns
each address point to spatial units (either H3 hexagonal cells or user-provided
polygons), and returns per-unit counts of \code{COD_ESPECIE} as \code{addr_type1} to
\code{addr_type8}.
}
\details{
The counts in the columns \code{addr_type1} to \code{addr_type8} correspond to:
\itemize{
\item \code{addr_type1}: Private household (Domicílio particular)
\item \code{addr_type2}: Collective household (Domicílio coletivo)
\item \code{addr_type3}: Agricultural establishment (Estabelecimento agropecuário)
\item \code{addr_type4}: Educational establishment (Estabelecimento de ensino)
\item \code{addr_type5}: Health establishment (Estabelecimento de saúde)
\item \code{addr_type6}: Establishment for other purposes (Estabelecimento de outras finalidades)
\item \code{addr_type7}: Building under construction or renovation (Edificação em construção ou reforma)
\item \code{addr_type8}: Religious establishment (Estabelecimento religioso)
}
}
\examples{
\donttest{
# Count addresses per H3 hexagon (resolution 9)
hex_counts <- cnefe_counts(code_muni = 2929057)

# Count addresses per user-provided polygon (neighborhoods of Lauro de Freitas-BA)
# Using geobr to download neighborhood boundaries
library(geobr)
nei_ldf <- subset(
  read_neighborhood(year = 2022),
  code_muni == 2919207
)
hex_counts <- cnefe_counts(
  code_muni = 2919207,
  polygon_type = "user",
  polygon = nei_ldf
)
}

}
