\name{trip_cast_score}
\alias{trip_cast_score}
\title{
TRIP-Cast Score for Thrombosis Risk Prediction
}
\description{
Calculates the TRIP-Cast score to estimate the risk of venous thromboembolism (VTE) in patients with lower limb immobilization (cast or brace). The score stratifies patients into low, moderate, or high risk groups.
}
\usage{
trip_cast_score(age, sex, bmi, oral_contraceptive, vte_history, cancer_history,
                cast_below_knee, mobility, surgery)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
<35: 0 pts.
35-55: 2 pts.
>55: 3 pts.
}
  \item{sex}{
String. Patient sex.
"Male": +1 pt.
"Female": 0 pts.
}
  \item{bmi}{
Numeric. Body Mass Index.
<25: 0 pts.
25-30: 1 pt.
>30: 2 pts.
}
  \item{oral_contraceptive}{
Numeric (0 or 1). Use of oral contraceptives/hormones. (1 = Yes, +4 pts).
}
  \item{vte_history}{
Numeric (0 or 1). Personal or family history of VTE (or superficial vein thrombosis). (1 = Yes, +5 pts).
}
  \item{cancer_history}{
Numeric (0 or 1). History of cancer. (1 = Yes, +3 pts).
}
  \item{cast_below_knee}{
Numeric (0 or 1). Is the cast/brace strictly below the knee?
1 (Yes): 0 pts.
0 (No/Above knee involvement): +1 pt.
}
  \item{mobility}{
Numeric (0 or 1). Severely restricted mobility (e.g., non-weight bearing). (1 = Yes, +2 pts).
}
  \item{surgery}{
Numeric (0 or 1). Surgery performed or planned. (1 = Yes, +3 pts).
}
}
\value{
A list containing:
\item{TRIP_Cast_Score}{The calculated risk score (Range 0-24).}
\item{Risk_Category}{Classification (Low < 7, Moderate 7-11, High >= 12).}
\item{Estimated_VTE_Risk}{Estimated 3-month cumulative VTE incidence.}
}
\references{
Nemeth B, van Adrichem RA, van Hylckama Vlieg A, et al. Venous thrombosis risk after cast immobilization of the lower extremity: the TRIP-cast score. Thromb Haemost. 2015;114(6):1242-1249. doi:10.1160/TH15-03-0197
}
\examples{

# Example 1: Low Risk
# 25yo Male, BMI 22, No Hx, Below Knee cast, Partial weight bearing, No Surgery
# Score = 0 (Age) + 1 (Male) + 0 (BMI) + 0 + 0 + 0 + 0 (BK) + 0 (Mobility) + 0 (Surg) = 1
trip_cast_score(25, "male", 22, 0, 0, 0, 1, 0, 0)

# Example 2: High Risk
# 40yo Female, BMI 32, OCP, Hx VTE, Below Knee, Non-weight bearing, No Surg
# Score = 2 (Age) + 0 (Fem) + 2 (BMI) + 4 (OCP) + 5 (Hx) + 0 + 0 + 2 (Mobility) + 0 = 15
trip_cast_score(40, "female", 32, 1, 1, 0, 1, 1, 0)
}
