\name{tenecteplase_dosing}
\alias{tenecteplase_dosing}
\title{
Tenecteplase (TNKase) Dosing Calculator
}
\description{
Calculates the recommended dose of Tenecteplase for the treatment of Acute Myocardial Infarction (STEMI) or Acute Ischemic Stroke. Dosing for STEMI is based on weight tiers, while dosing for stroke is calculated as 0.25 mg/kg with a maximum limit.
}
\usage{
tenecteplase_dosing(weight_kg, indication = "stemi")
}
\arguments{
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{indication}{
String. Clinical indication for treatment. Options: "stemi" (default) or "stroke".
STEMI Dosing:
<60 kg: 30 mg
60-69 kg: 35 mg
70-79 kg: 40 mg
80-89 kg: 45 mg
>=90 kg: 50 mg
Stroke Dosing: 0.25 mg/kg (Max 25 mg).
}
}
\value{
A list containing:
\item{Recommended_Dose_mg}{The calculated dose in milligrams.}
\item{Volume_to_Administer_mL}{The volume to administer in milliliters (based on standard 5 mg/mL reconstitution).}
}
\references{
TNKase (Tenecteplase) [Package Insert]. South San Francisco, CA: Genentech, Inc.
Haley EC Jr, et al. Tenecteplase in acute ischemic stroke: results of a randomized controlled trial. Stroke. 2010;41(4):707-711.
}
\examples{

# Example 1: STEMI, 75 kg
# Tier 70-79kg -> 40 mg
tenecteplase_dosing(75, "stemi")

# Example 2: Stroke, 110 kg
# 0.25 * 110 = 27.5 mg -> Capped at 25 mg
tenecteplase_dosing(110, "stroke")
}
