\name{rome_iv_functional_pancreatic_sod}
\alias{rome_iv_functional_pancreatic_sod}
\title{
Rome IV Diagnostic Criteria for Functional Pancreatic Sphincter of Oddi Disorder (SOD)
}
\description{
Evaluates the Rome IV diagnostic criteria for Functional Pancreatic Sphincter of Oddi Disorder. Diagnosis requires recurrent, episodic pain of presumed pancreatic origin, absence of other pathology (structural, metabolic, imaging), and elevated sphincter of Oddi basal pressure documented by manometry. This disorder is characterized by presumed intermittent obstruction to pancreatic fluid outflow.
}
\usage{
rome_iv_functional_pancreatic_sod(biliary_pain,
normal_enzymes, normal_imaging,
manometry_high, not_explained_by_other_condition,
symptom_onset_ge_6_months, symptoms_active_last_3_months)
}
\arguments{
  \item{biliary_pain}{
Numeric (0 or 1). Presence of recurrent, episodic pain of presumed pancreatic origin (consistent with recurrent pancreatitis). (1 = Yes).
}
  \item{normal_enzymes}{
Numeric (0 or 1). Documentation of normal pancreatic enzymes (amylase/lipase) *between* pain episodes. (1 = Yes).
}
  \item{normal_imaging}{
Numeric (0 or 1). Documentation of no pancreatic structural pathology (e.g., mass, chronic pancreatitis changes) on imaging (e.g., EUS, CT, or MRCP). (1 = Yes).
}
  \item{manometry_high}{
Numeric (0 or 1). Elevated sphincter of Oddi basal pressure documented by manometry (a pressure >= 40 mmHg is diagnostic). (1 = Yes).
}
  \item{not_explained_by_other_condition}{
Numeric (0 or 1). Are symptoms NOT fully explained by another medical condition? (1 = Yes).
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptom onset occur at least 6 months prior to diagnosis? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have symptoms been active for the last 3 months? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Functional Pancreatic Sphincter of Oddi Disorder (SOD)" or "Criteria Not Met".}
}
\references{
Corazziari E, Shaffer EA, Hogan WJ, et al. Functional Disorders of the Gallbladder and Sphincter of Oddi. Gastroenterology. 2016;150:1443-1455. doi:10.1053/j.gastro.2016.02.044
}
\examples{

# Example 1: Diagnosis Met
# All exclusion criteria and symptom characteristics are met and manometry is positive
rome_iv_functional_pancreatic_sod(1, 1, 1, 1, 1, 1, 1)

# Example 2: Not Met (Manometry Negative/Normal)
# All clinical/imaging criteria met, but manometry is normal (0)
rome_iv_functional_pancreatic_sod(1, 1, 1, 0, 1, 1, 1)
}
