\name{mskcc_additional_nodal_metastasis}
\alias{mskcc_additional_nodal_metastasis}
\title{
MSKCC Additional Nodal Metastasis Nomogram
}
\description{
Calculates the probability of having additional non-sentinel lymph node (NSLN) metastases in breast cancer patients who have a positive sentinel lymph node (SLN). This function implements the logistic regression model from the Memorial Sloan Kettering Cancer Center (MSKCC) nomogram developed by Van Zee et al. It uses pathologic variables to predict the likelihood of residual disease in the axilla.
}
\usage{
mskcc_additional_nodal_metastasis(frozen_section_pos, method_detection,
                                  tumor_size_cm, lvi, multifocality,
                                  num_pos_sln, num_neg_sln)
}
\arguments{
  \item{frozen_section_pos}{
Numeric (0 or 1). Was the sentinel node metastasis identified on intraoperative frozen section? (1 = Yes, 0 = No).
}
  \item{method_detection}{
String. Method of detection if frozen section was negative or not done.
"routine": Routine H&E staining (associated with higher risk than specialized detection).
"serial": Serial H&E or Immunohistochemistry (IHC).
}
  \item{tumor_size_cm}{
Numeric. Pathologic tumor size in centimeters.
}
  \item{lvi}{
Numeric (0 or 1). Lymphovascular Invasion present? (1 = Yes, 0 = No).
}
  \item{multifocality}{
Numeric (0 or 1). Multifocality present? (1 = Yes, 0 = No).
}
  \item{num_pos_sln}{
Numeric. Number of positive sentinel lymph nodes found.
}
  \item{num_neg_sln}{
Numeric. Number of negative sentinel lymph nodes found.
}
}
\value{
A list containing:
\item{Probability_Non_SLN_Metastasis}{The estimated percentage probability of finding additional metastasis in the non-sentinel nodes.}
\item{Inputs}{A list of the processed input variables.}
}
\references{
Van Zee KJ, Manasseh DM, Bevilacqua JL, et al. A nomogram for predicting the likelihood of additional nodal metastases in breast cancer patients with a positive sentinel node biopsy. Ann Surg Oncol. 2003;10(10):1140-1151. doi:10.1245/aso.2003.03.015
}
\examples{

# Example 1: High Risk
# Frozen section positive, 2.5cm tumor, LVI positive, 2 Pos SLN, 0 Neg SLN
mskcc_additional_nodal_metastasis(1, "n/a", 2.5, 1, 0, 2, 0)

# Example 2: Low Risk
# Routine H&E, 1.2cm tumor, No LVI, 1 Pos SLN, 3 Neg SLN
mskcc_additional_nodal_metastasis(0, "routine", 1.2, 0, 0, 1, 3)
}
