% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{clinTrialData-data}
\alias{clinTrialData-data}
\alias{clinical-data}
\alias{cdisc-pilot}
\title{Clinical Trial Datasets}
\source{
CDISC Pilot 01 Study Data
Various clinical trial data sources
}
\description{
The clinTrialData package contains clinical trial datasets from
multiple sources, stored in Parquet format. Data is accessed
using connector functions.
}
\section{Available Data Sources}{
\subsection{CDISC Pilot 01 Study}{

The CDISC Pilot 01 study data includes both ADaM and SDTM domains.

\strong{ADaM datasets include:}
\itemize{
\item ADSL: Subject-Level Analysis Dataset
\item ADAE: Adverse Events Analysis Dataset
\item ADLB: Laboratory Analysis Dataset (combined)
\item ADLBC: Laboratory Analysis Dataset (Chemistry)
\item ADLBH: Laboratory Analysis Dataset (Hematology)
\item ADLBHY: Laboratory Analysis Dataset (Hy's Law)
\item ADQSADAS: ADAS-Cog Questionnaire Analysis Dataset
\item ADQSCIBC: CIBC Questionnaire Analysis Dataset
\item ADQSNPIX: NPI-X Questionnaire Analysis Dataset
\item ADTTE: Time-to-Event Analysis Dataset
\item ADVS: Vital Signs Analysis Dataset
}

\strong{SDTM datasets include:}
\itemize{
\item DM: Demographics
\item AE: Adverse Events
\item VS: Vital Signs
\item LB: Laboratory Test Results
\item And 18 additional domains (see \code{list_data_sources()} for details)
}
}
}

\section{Usage}{
Data sources are discovered by scanning the package directory structure.
List available datasets with \code{list_data_sources()}.

Access data using the connection function:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Connect to any data source (e.g., CDISC Pilot data)
db <- connect_clinical_data("cdisc_pilot")

# List available datasets
db$adam$list_content_cnt()

# Read a dataset
adsl <- db$adam$read_cnt("adsl")

# See all available data sources
list_data_sources()
}\if{html}{\out{</div>}}
}

\section{Data Format}{
Datasets are stored in Parquet format:
\itemize{
\item Columnar storage
\item Fast reads
\item Compression
\item Cross-platform compatibility
}
}

\references{
CDISC. Clinical Data Interchange Standards Consortium.
\url{https://www.cdisc.org/}
}
\keyword{datasets}
