% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdisc_validate.R
\name{validate_sdtm}
\alias{validate_sdtm}
\title{Validate SDTM Compliance}
\usage{
validate_sdtm(df, domain)
}
\arguments{
\item{df}{A data frame to validate.}

\item{domain}{Character string specifying the SDTM domain code (e.g., "DM", "AE", "VS").}
}
\value{
A data frame with validation results containing columns:
\item{category}{Character: validation issue type}
\item{variable}{Character: variable name}
\item{message}{Character: issue description}
\item{severity}{Character: "ERROR", "WARNING", or "INFO"}
}
\description{
Validates a data frame against a specific SDTM domain specification. Checks for
missing required/expected variables, data type mismatches, and non-standard variables.
}
\details{
Severity levels:
\itemize{
\item ERROR: Required variable is missing
\item WARNING: Expected variable is missing or data type mismatch detected
\item INFO: Non-standard variable present or variable information
}
}
\keyword{internal}
