% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_datasets.R
\name{prepare_datasets}
\alias{prepare_datasets}
\title{Prepare Datasets for Comparison}
\usage{
prepare_datasets(df1, df2, sort_columns = NULL, filter_criteria = NULL)
}
\arguments{
\item{df1}{First dataset to be prepared.}

\item{df2}{Second dataset to be prepared.}

\item{sort_columns}{Columns to sort the datasets by.}

\item{filter_criteria}{Criteria for filtering the datasets.}
}
\value{
A list containing two prepared datasets.
}
\description{
Prepares two datasets for comparison by optionally sorting by specified columns
and filtering rows based on a condition.
}
\examples{
\donttest{
  df1 <- data.frame(id = c(3, 1, 2), score = c(70, 90, 80))
  df2 <- data.frame(id = c(2, 3, 1), score = c(80, 75, 90))
  prepare_datasets(df1, df2, sort_columns = "id", filter_criteria = "score > 75")
}
}
