% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word_counts.R
\name{word_counts}
\alias{word_counts}
\title{Get word counts by speaker role}
\usage{
word_counts(
  word_list_file = NULL,
  output_file,
  words = NULL,
  collection = NULL,
  language = NULL,
  corpus = NULL,
  age = NULL,
  sex = NULL,
  role = NULL,
  role_exclude = NULL,
  wildcard = FALSE,
  collapse = c("none", "stem"),
  part_of_speech = NULL,
  tier = c("main", "mor"),
  normalize = FALSE,
  per = 1000L,
  zipf = FALSE,
  include_patterns = NULL,
  exclude_patterns = NULL,
  sort_by = c("word", "frequency"),
  min_count = 0L,
  freq_ignore_special = TRUE,
  db_version = "current",
  cache = FALSE,
  cache_dir = NULL,
  ...
)
}
\arguments{
\item{word_list_file}{Optional path to a CSV file with a column named \code{word}.
If NULL and \code{words} is also NULL, all types in the slice are counted.}

\item{output_file}{Path to the output \code{.xlsx} file.}

\item{words}{Optional character vector of target words/patterns. Ignored if
\code{word_list_file} is provided. If both are NULL, all types are counted.}

\item{collection}{Optional CHILDES filter.}

\item{language}{Optional CHILDES filter.}

\item{corpus}{Optional CHILDES filter.}

\item{age}{Optional numeric: single value or c(min, max) in months.}

\item{sex}{Optional: "male" and/or "female".}

\item{role}{Optional character vector of roles to include.}

\item{role_exclude}{Optional character vector of roles to exclude.}

\item{wildcard}{Logical; treat \code{"\%"} as any number of characters and
\code{"_"} as one character (token mode).}

\item{collapse}{Either "none" or "stem". Using "stem" triggers token mode.}

\item{part_of_speech}{Optional POS filter, e.g., c("n","v") (token mode).}

\item{tier}{Which tier to count from: "main" or "mor".}

\item{normalize}{Logical; if TRUE, add per-N rate columns.}

\item{per}{Integer denominator for rates (for example 1000 for per-1k).}

\item{zipf}{Logical; if TRUE, also add Zipf columns (log10 per-billion).}

\item{include_patterns}{Optional character vector of CHILDES-style patterns,
using \code{"\%"} and \code{"_"} to restrict output to matching words (FREQ-style +s).}

\item{exclude_patterns}{Optional character vector of CHILDES-style patterns
to drop from the output.}

\item{sort_by}{Final sort order: "word" (alphabetical) or "frequency"
(descending Total).}

\item{min_count}{Integer; drop rows with Total < min_count (after counting).}

\item{freq_ignore_special}{Logical; if TRUE, drop "xxx", "www", and any word
starting with 0, &, +, -, or # (FREQ default ignore rules).}

\item{db_version}{CHILDES database version label to record in metadata.}

\item{cache}{Logical; if TRUE, cache CHILDES queries on disk.}

\item{cache_dir}{Optional cache directory when cache = TRUE.}

\item{...}{Reserved for future extensions; currently unused.}
}
\value{
Invisibly returns \code{output_file} after writing the workbook.
}
\description{
Reads a CSV with a \code{word} column or an in-memory character vector and writes
an Excel file with Word_Frequencies, Dataset_Summary, File_Speaker_Summary,
and Run_Metadata. If no word list is provided, all types in the selected
slice are counted (FREQ-style “all words” mode).
}
\details{
Uses exact type counts by default; switches to token mode when wildcards,
stems, or POS filters are requested. Optional MOR-only tier.
}
\examples{
\dontrun{
# Minimal example (not run during R CMD check)
tmp_csv <- tempfile(fileext = ".csv")
write.csv(data.frame(word = c("the","go")), tmp_csv, row.names = FALSE)

out_file <- tempfile(fileext = ".xlsx")
word_counts(
  word_list_file = tmp_csv,
  output_file    = out_file,
  language       = "eng",
  corpus         = "Brown",
  age            = c(24, 26)
)

# All-words mode (no word list; counts every type in the slice)
out_all <- tempfile(fileext = ".xlsx")
word_counts(
  word_list_file = NULL,
  words          = NULL,
  output_file    = out_all,
  language       = "eng",
  corpus         = "Brown",
  age            = c(24, 26)
)
}
}
