% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gfci.R
\name{gfci}
\alias{gfci}
\title{GFCI Algorithm for Causal Discovery}
\usage{
gfci(engine = "tetrad", score, test, alpha = 0.05, ...)
}
\arguments{
\item{engine}{Character; which engine to use. Must be one of:
\describe{
\item{\code{"tetrad"}}{\pkg{Tetrad} Java library.}
}}

\item{score}{Character; name of the scoring function to use.}

\item{test}{Character; name of the conditional‐independence test.}

\item{alpha}{Numeric; significance level for the CI tests.}

\item{...}{Additional arguments passed to the chosen engine (e.g. score and
algorithm parameters).}
}
\description{
Run the GFCI (Greedy Fast Causal Inference) algorithm for causal discovery using one of several engines. This
combines the FGES and FCI algorithms.
}
\details{
For specific details on the supported scores, and parameters for each engine, see:
\itemize{
\item \link{TetradSearch} for \pkg{Tetrad}.
}
}
\section{Recommendation}{

While it is possible to call the function returned directly with a data frame,
we recommend using \code{\link[=disco]{disco()}}. This provides a consistent interface and handles knowledge
integration.
}

\section{Value}{

A function that takes a single argument \code{data} (a data frame). When called,
this function returns a list containing:
\itemize{
\item \code{knowledge} A \code{Knowledge} object with the background knowledge
used in the causal discovery algorithm. See \code{\link[=knowledge]{knowledge()}} for how to construct it.
\item \code{caugi} A \code{\link[caugi:caugi]{caugi::caugi}} object representing the learned causal graph.
This graph is a PAG (Partial Ancestral Graph), but since PAGs are not yet
natively supported in \code{caugi}, it is currently stored with class \code{UNKNOWN}.
}
}

\examples{
data(num_data)

# Requires Tetrad to be installed
if (verify_tetrad()$installed && verify_tetrad()$java_ok) {
  # Recommended path using disco()
  gfci_tetrad <- gfci(
    engine = "tetrad",
    score = "sem_bic",
    test = "fisher_z"
  )
  disco(tpc_example, gfci_tetrad)

  # or using gfci_tetrad directly
  gfci_tetrad(tpc_example)
}

#### With tier knowledge ####
if (verify_tetrad()$installed && verify_tetrad()$java_ok) {
  kn <- knowledge(
    tpc_example,
    tier(
      child ~ tidyselect::starts_with("child"),
      youth ~ tidyselect::starts_with("youth"),
      oldage ~ tidyselect::starts_with("oldage")
    )
  )

  # Recommended path using disco()
  gfci_tetrad <- gfci(
    engine = "tetrad",
    score = "sem_bic",
    test = "fisher_z"
  )
  disco(tpc_example, gfci_tetrad, knowledge = kn)

  # or using gfci_tetrad directly
  gfci_tetrad <- gfci_tetrad |> set_knowledge(kn)
  gfci_tetrad(tpc_example)
}

# With all algorithm arguments specified
if (verify_tetrad()$installed && verify_tetrad()$java_ok) {
  gfci_tetrad <- gfci(
    engine = "tetrad",
    score = "poisson_prior",
    test = "rank_independence",
    depth = 3,
    max_degree = 2,
    max_disc_path_length = 5,
    use_heuristic = FALSE,
    complete_rule_set_used = FALSE,
    guarantee_pag = TRUE,
    start_complete = TRUE,
    num_threads = 2,
    verbose = TRUE
  )
  disco(num_data, gfci_tetrad)
}
}
\seealso{
Other causal discovery algorithms: 
\code{\link{boss}()},
\code{\link{boss_fci}()},
\code{\link{fci}()},
\code{\link{ges}()},
\code{\link{grasp}()},
\code{\link{grasp_fci}()},
\code{\link{gs}()},
\code{\link{iamb-family}},
\code{\link{pc}()},
\code{\link{sp_fci}()},
\code{\link{tfci}()},
\code{\link{tges}()},
\code{\link{tpc}()}
}
\concept{causal discovery algorithms}
\concept{cd_algorithms}
