% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causalDisco-package.R
\docType{package}
\name{causalDisco-package}
\alias{causalDisco}
\alias{causalDisco-package}
\title{causalDisco: Causal Discovery in R}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Tools for causal structure learning from observational data, with emphasis on temporally ordered variables. The package implements the Temporal Peter–Clark (TPC) algorithm (Petersen, Osler & Ekstrøm, 2021; \doi{10.1093/aje/kwab087}), the Temporal Greedy Equivalence Search (TGES) algorithm (Larsen, Ekstrøm & Petersen, 2025; \doi{10.48550/arXiv.2502.06232}) and Temporal Fast Causal Inference (TFCI). It provides a unified framework for specifying background knowledge, which can be incorporated into the implemented algorithms from the R packages 'bnlearn' (Scutari, 2010; \doi{10.18637/jss.v035.i03}) and 'pcalg' (Kalish et al., 2012; \doi{10.18637/jss.v047.i11}), as well as the Java library 'Tetrad' (Scheines et al., 1998; \doi{10.1207/s15327906mbr3301_3}). The package further includes utilities for visualization, comparison, and evaluation of graph structures, facilitating performance evaluation and methodological studies.
}
\section{System requirements (optional)}{

If you want to use algorithms from the Java library Tetrad, a Java JDK (>= 21) is required.
The Tetrad \code{.jar} file can be downloaded using \code{\link[=install_tetrad]{install_tetrad()}}.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/disco-coders/causalDisco}
  \item \url{https://disco-coders.github.io/causalDisco/}
  \item Report bugs at \url{https://github.com/disco-coders/causalDisco/issues}
}

}
\author{
\strong{Maintainer}: Bjarke Hautop Kristensen \email{bjarke.kristensen@sund.ku.dk}

Authors:
\itemize{
  \item Frederik Fabricius-Bjerre \email{frederik@fabriciusbjerre.dk}
  \item Anne Helby Petersen \email{ahpe@sund.ku.dk}
}

Other contributors:
\itemize{
  \item Claus Thorn Ekstrøm \email{ekstrom@sund.ku.dk} [contributor]
  \item Tobias Ellegaard Larsen \email{tobias.ellegaard@sund.ku.dk} [contributor]
}

}
