% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_discrim.R
\name{plot_discrim}
\alias{plot_discrim}
\title{Create a discriminant analysis decision plot using ggplot.}
\usage{
plot_discrim(
  model,
  vars,
  data,
  resolution = 100,
  contour = TRUE,
  contour.color = "black",
  point.size = 3,
  showgrid = c("tile", "point", "none"),
  ...,
  modes.means
)
}
\arguments{
\item{model}{a discriminant analysis model object from \code{MASS::lda()} or \code{MASS::qda()}}

\item{vars}{either a character vector of length 2 of the names of variables, or a formula of form V1 ~ V2 specifying y and x axis in the plot respectively.}

\item{data}{data to use for visualization. Should contain all the data needed to use the model}

\item{resolution}{number of points in x, y variables to use for visualizating the predicted class boundaries and regions.}

\item{contour}{logical; should the plot display the boundaries of the classes by contours?}

\item{contour.color}{color of the lines for the contour boundaries}

\item{point.size}{size of the plot symbols use to show the data observations}

\item{showgrid}{a character string; how to display predicted class regions: \code{"tile"} for \code{\link[ggplot2:geom_tile]{ggplot2::geom_tile()}}, \code{"point"}
for \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}, or \code{"none"} for no grid display.}

\item{...}{further parameters passed to \code{predict()}}

\item{modes.means}{levels to use for evaluating predictions using the variables *\emph{not} specified in \code{vars}. If not specified, the function uses the means for quantitative variables, ...}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Discriminant analysis can be more easily understood from plots of the data variables showing how observations are classified.
\code{plot_discrim()} uses the ideas behind effect plots: Visualize predicted values for two focal variables over a
grid, with other variables in a model held fixed.
}
\details{
In setting up this plot for \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}, this function maps color and shape of class-specific elements of the plot to the value of
the class variable in the discriminant analysis. But it simply uses the ggplot defaults...
}
\examples{
library(MASS)
library(ggplot2)
library(dplyr)
library(candisc)

iris.lda <- lda(Species ~ ., iris)
plot_discrim(iris.lda, Petal.Length ~ Petal.Width, data=iris, showgrid = "tile")

}
\seealso{
\code{\link[klaR:partimat]{klaR::partimat()}}
}
\author{
Original code by Oliver on SO \url{https://stackoverflow.com/questions/63782598/quadratic-discriminant-analysis-qda-plot-in-r}. Generalized by Michael Friendly
}
