% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_lda.R
\name{cor_lda}
\alias{cor_lda}
\title{Calculate Structure Correlations from Discriminant Analysis}
\usage{
cor_lda(
  object,
  prior = object$prior,
  dimen,
  method = c("pearson", "kendall", "spearman"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{"lda"} such as results from \code{\link[MASS:lda]{MASS::lda()}}}

\item{prior}{The prior probabilities of the classes. By default, taken to be the proportions in what was set
in the call to \code{\link[MASS:lda]{MASS::lda()}}}

\item{dimen}{The dimension of the space to be used. If this is less than the number of available dimensions,
\eqn{\min(p, ng-1)}, only the first \code{dimen} discriminant components are used.}

\item{method}{a character string indicating which correlation coefficient is to be computed. One of \code{"pearson"}
(default), \code{"kendall"}, or \code{"spearman"}: can be abbreviated. See \code{\link[stats:cor]{stats::cor()}} for details}

\item{...}{other arguments (presently ignored)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{  a numeric matrix of correlations, of size `nv` = number of predictor variables * `dimen`
}\if{html}{\out{</div>}}
}
\description{
\code{cor_lda()} calculates the "structure" correlations between the observed variables and the discriminant dimension scores
from a linear discriminant analysis provided by \code{\link[MASS:lda]{MASS::lda()}}.  These more directly assess the direction and strength
of the relations between the two sets than do the \code{scaling} weights returned by \code{lda()}. They are useful for plotting
the discriminant scores, showing the contributions of the variables by vectors.
}
\examples{
library(candisc)
library(MASS)   # for lda()

iris.lda <- lda(Species ~ ., iris)
cor_lda(iris.lda)

}
\seealso{
\code{\link[=predict_discrim]{predict_discrim()}}, \code{\link[MASS:lda]{MASS::lda()}}, \code{\link[stats:cor]{stats::cor()}}
}
\author{
Michael Friendly
}
