% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calba.R
\name{neigh_multi_r}
\alias{neigh_multi_r}
\title{Neighborhood metrics across multiple radii}
\usage{
neigh_multi_r(
  sp,
  gx,
  gy,
  ba,
  r_values,
  dist_weighted = FALSE,
  edge_correction = c("none", "safe"),
  bounds = NULL
)
}
\arguments{
\item{sp}{A character or factor vector of species names.}

\item{gx}{Numeric x-coordinates of the trees.}

\item{gy}{Numeric y-coordinates of the trees.}

\item{ba}{Numeric basal area for each tree.}

\item{r_values}{Numeric vector of radii to evaluate.}

\item{dist_weighted}{Logical flag to use `ba / dist` weighting within each radius.}

\item{edge_correction}{Character; see `ba_simple()` for the `"safe"` option.}

\item{bounds}{Optional numeric vector `c(xmin, xmax, ymin, ymax)` giving the plot extent.
When `NULL`, the range of `gx`/`gy` is used; supply bounds if your data do not span the full plot.}
}
\value{
A tidy tibble with `tree_id`, `species`, `radius`, `con_ba`, `total_ba`,
`con_count`, `total_count`, `prop_con_ba`, `het_ba`, `het_count`, and
`competition_index`.
}
\description{
Compute basal area sums and counts for each tree across multiple radii in one pass.
}
\examples{
sample_data <- data.frame(
  latin = sample(letters[1:4], 10, replace = TRUE),
  gx = runif(10, 0, 10),
  gy = runif(10, 0, 10),
  ba = runif(10, 10, 30)
)
neigh_multi_r(
  sp = sample_data$latin,
  gx = sample_data$gx,
  gy = sample_data$gy,
  ba = sample_data$ba,
  r_values = c(3, 5)
)

}
