% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{check_monotonicity}
\alias{check_monotonicity}
\title{Check Monotonicity of Predicted Values}
\usage{
check_monotonicity(lm_model, pred_data, minRaw, maxRaw)
}
\arguments{
\item{lm_model}{An object of class 'lm' representing the fitted linear model.}

\item{pred_data}{Matrix with prediction values}

\item{minRaw}{lowest raw score in prediction}

\item{maxRaw}{highest raw score in prediction}
}
\value{
A named character vector where each element corresponds to an age point.
        Possible values for each element are 1 for "Monotonically increasing"
        -1 for "Monotonically decreasing", or 0 for "Not monotonic".
}
\description{
This function checks if the predicted values from a linear model are
monotonically increasing or decreasing across a range of L values for
multiple age points.
}
\details{
The function creates a prediction data frame using all combinations
         of the provided L values and age points. It then generates predictions
         using the provided linear model and checks if these predictions are
         monotonically increasing or decreasing for each age point across the
         range of L values.
}
