% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_bundestag_lobbyregister.R
\name{bundestag_lobbyregister_search}
\alias{bundestag_lobbyregister_search}
\title{Search the Bundestag lobbyregister}
\usage{
bundestag_lobbyregister_search(
  q = NULL,
  sort = NULL,
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{q}{Optional search string.}

\item{sort}{Optional sorting order.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with search metadata and result entries.
}
\description{
Search the Bundestag lobbyregister
}
\details{
Returns search results from the Bundestag lobbyregister.
Official docs: https://bundesapi.github.io/bundestag-lobbyregister-api/.
}
\examples{
\dontrun{
bundestag_lobbyregister_search(q = "energie")
}

}
