## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)

## ----setup--------------------------------------------------------------------
# library(bracketeer)

## -----------------------------------------------------------------------------
# my_spec <- spec() |>
#   round_robin("groups") |>
#   single_elim("finals", take = top_n(8))
# 
# validate(my_spec, n = 6)
# # Error: stage 'finals' requires 8 participants via `top_n(8)` but source
# # stage 'groups' can produce at most 6. Adjust the selector or increase
# # participant count (currently n = 6).

## -----------------------------------------------------------------------------
# trn <- tournament(paste("Team", 1:8)) |>
#   round_robin("league") |>
#   single_elim("playoffs", take = top_per_group(2))
# # Error: `top_per_group()` requires the source stage 'league' to have
# # groups, but it was defined without `groups =`. Use `top_n()` for flat
# # standings, or add `groups =` to the source stage.

## -----------------------------------------------------------------------------
# spec() |>
#   single_elim("finals", from = previous_stage())
# # Error: `previous_stage()` in stage 'finals' resolved to no prior stage.
# # 'finals' is the first stage in this spec. Provide an explicit `from =`
# # or add a source stage before it.

## -----------------------------------------------------------------------------
# spec() |>
#   round_robin("groups") |>
#   single_elim("finals", take = top_n(8))  # from = previous_stage() is implicit, resolves to "groups"

## -----------------------------------------------------------------------------
# tournament(paste("Team", 1:16)) |>
#   round_robin("groups") |>
#   single_elim("finals", from = "typo_stage", take = top_n(8))
# # Error: `from = "typo_stage"` in stage 'finals' references a stage that
# # does not exist. Known stages: groups. Check the stage ID spelling.

## -----------------------------------------------------------------------------
# tournament(paste("Team", 1:16)) |>
#   round_robin("groups") |>
#   single_elim("championship", from = "groups", take = top_n(8)) |>
#   single_elim("consolation",  from = "groups", take = top_n(8))  # same 8!
# # Error: stages 'championship' and 'consolation' both consume overlapping
# # participants from source 'groups'. Use `remaining()` for the second
# # branch to select the leftover pool, or adjust selectors to be disjoint.

## -----------------------------------------------------------------------------
# tournament(paste("Team", 1:16)) |>
#   round_robin("groups") |>
#   single_elim("championship", from = "groups", take = top_n(8)) |>
#   single_elim("consolation",  from = "groups", take = remaining())

## -----------------------------------------------------------------------------
# # After all group results have been entered and "knockout" has materialized:
# trn <- trn |> result("groups", match = 1, score = c(0, 2))
# # Error: result for match 1 in stage 'groups' cannot be overwritten because
# # downstream stage 'knockout' has already been materialized from 'groups'.
# # Use teardown(trn, "knockout") first to unlock result editing.

## -----------------------------------------------------------------------------
# trn <- teardown(trn, "knockout")
# trn <- trn |> result("groups", match = 1, score = c(0, 2))
# # "knockout" will re-materialize automatically when groups is complete again.

## -----------------------------------------------------------------------------
# spec() |>
#   round_robin("stage") |>
#   single_elim("stage")  # duplicate!
# # Error: stage ID 'stage' is already registered. Stage IDs must be unique.
# # Provide a distinct ID for each stage.

## -----------------------------------------------------------------------------
# trn <- trn |> result("groups", match = 1, score = 2)
# # Error: `score` must be a numeric vector of length >= 2 (e.g., c(2, 1)).
# # Received: a single value (2). Did you mean score = c(2, 1)?

