% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.ForecastsPANEL}
\alias{summary.ForecastsPANEL}
\title{Provides posterior summary of country-specific Forecasts}
\usage{
\method{summary}{ForecastsPANEL}(object, which_c, ...)
}
\arguments{
\item{object}{an object of class \code{ForecastsPANEL} obtained using the
\code{forecast()} function containing draws the predictive density.}

\item{which_c}{a positive integer or a character string specifying the country 
for which the forecast should be plotted.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A list reporting the posterior mean, standard deviations, as well as 
5 and 95 percentiles of the forecasts for each of the variables and forecast 
horizons.
}
\description{
Provides posterior summary of the forecasts including their 
mean, standard deviations, as well as 5 and 95 percentiles.
}
\examples{
# specify the model
specification = specify_bvarPANEL$new(
      ilo_dynamic_panel[1:5], 
      exogenous = ilo_exogenous_variables[1:5])
burn_in       = estimate(specification, 5)             # run the burn-in
posterior     = estimate(burn_in, 5)                   # estimate the model

# forecast 6 years ahead
predictive    = forecast(
      posterior, 
      5, 
      exogenous_forecast = ilo_exogenous_forecasts[1:5])
summary(predictive, which_c = "ARG")

}
\seealso{
\code{\link{forecast.PosteriorBVARPANEL}}, \code{\link{plot}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
