% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bernoulli_distribution.R
\name{bernoulli_distribution}
\alias{bernoulli_distribution}
\alias{bernoulli_pdf}
\alias{bernoulli_lpdf}
\alias{bernoulli_cdf}
\alias{bernoulli_lcdf}
\alias{bernoulli_quantile}
\title{Bernoulli Distribution Functions}
\usage{
bernoulli_distribution(p_success)

bernoulli_pdf(x, p_success)

bernoulli_lpdf(x, p_success)

bernoulli_cdf(x, p_success)

bernoulli_lcdf(x, p_success)

bernoulli_quantile(p, p_success)
}
\arguments{
\item{p_success}{probability of success (0 <= p_success <= 1)}

\item{x}{quantile (0 or 1)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Bernoulli distribution.
}
\examples{
# Bernoulli distribution with p_success = 0.5
dist <- bernoulli_distribution(0.5)
# Apply generic functions
cdf(dist, 0.5)
logcdf(dist, 0.5)
pdf(dist, 0.5)
logpdf(dist, 0.5)
hazard(dist, 0.5)
chf(dist, 0.5)
mean(dist)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
standard_deviation(dist)
support(dist)
variance(dist)
skewness(dist)
kurtosis(dist)
kurtosis_excess(dist)

# Convenience functions
bernoulli_pdf(1, 0.5)
bernoulli_lpdf(1, 0.5)
bernoulli_cdf(1, 0.5)
bernoulli_lcdf(1, 0.5)
bernoulli_quantile(0.5, 0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/bernoulli_dist.html}{Boost Documentation} for more details on the mathematical background.
}
