% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{new_write_block}
\alias{new_write_block}
\title{Unified file writing block}
\usage{
new_write_block(
  directory = "",
  filename = "",
  format = "csv",
  mode = "download",
  auto_write = FALSE,
  args = list(),
  ...
)
}
\arguments{
\item{directory}{Character. Default directory for file output (browse mode only).
Can be configured via \code{options(blockr.write_dir = "/path")} or environment
variable \code{BLOCKR_WRITE_DIR}. Default: \code{tempdir()}.}

\item{filename}{Character. Optional fixed filename (without extension).
\itemize{
\item \strong{If provided}: Writes to same file path on every upstream change (auto-overwrite)
\item \strong{If empty} (default): Generates timestamped filename (e.g., \code{data_20250127_143022.csv})
}}

\item{format}{Character. Output format: "csv", "excel", "parquet", or "feather".
Default: "csv"}

\item{mode}{Character. Either "download" for "To Browser" (triggers browser download),
or "browse" for "To Server" (writes to server filesystem). Default: "download"}

\item{auto_write}{Logical. When TRUE, automatically writes files when data changes
(browse mode only). When FALSE (default), user must click "Submit" button to save.
Has no effect in download mode.}

\item{args}{Named list of format-specific writing parameters. Only specify values
that differ from defaults. Available parameters:
\itemize{
\item \strong{For CSV files:} \code{sep} (default: ","), \code{quote} (default: TRUE),
\code{na} (default: "")
\item \strong{For Excel/Arrow:} Minimal options needed (handled by underlying packages)
}}

\item{...}{Forwarded to \code{\link[blockr.core:new_transform_block]{blockr.core::new_transform_block()}}}
}
\value{
A blockr transform block that writes dataframes to files
}
\description{
A variadic block for writing dataframes to files in various formats.
Accepts multiple input dataframes and handles single files, multi-sheet
Excel, or ZIP archives depending on format and number of inputs.
}
\details{
\subsection{Variadic Inputs}{

This block accepts multiple dataframe inputs (1 or more) similar to \code{bind_rows_block}.
Inputs can be numbered ("1", "2", "3") or named ("sales_data", "inventory").
Input names are used for sheet names (Excel) or filenames (multi-file ZIP).
}

\subsection{File Output Behavior}{

\strong{Single input:}
\itemize{
\item Writes single file in specified format
\item Filename: \verb{\{filename\}.\{ext\}} or \verb{data_\{timestamp\}.\{ext\}}
}

\strong{Multiple inputs + Excel:}
\itemize{
\item Single Excel file with multiple sheets
\item Sheet names derived from input names
}

\strong{Multiple inputs + CSV/Arrow:}
\itemize{
\item Single ZIP file containing individual files
\item Each file named from input names
}
}

\subsection{Filename Behavior}{

\strong{Fixed filename} (\code{filename = "output"}):
\itemize{
\item Reproducible path: always writes to \verb{\{directory\}/output.\{ext\}}
\item Overwrites file on every upstream data change
\item Ideal for automated pipelines
}

\strong{Auto-timestamped} (\code{filename = ""}):
\itemize{
\item Unique files: \verb{\{directory\}/data_YYYYMMDD_HHMMSS.\{ext\}}
\item Preserves history, prevents accidental overwrites
\item Safe default behavior
}
}

\subsection{Mode: To Browser vs To Server}{

\strong{To Browser mode} (download):
\itemize{
\item Exports files to your computer
\item Triggers a download to your browser's download folder
\item Useful for exporting results
}

\strong{To Server mode} (browse):
\itemize{
\item Saves files directly on the server
\item User selects directory with file browser
\item Files persist on server
\item When running locally, this is your computer's file system
}
}
}
\examples{
# Create a write block for CSV output
block <- new_write_block(
  directory = tempdir(),
  filename = "output",
  format = "csv"
)
block

# Write block for Excel with auto-timestamp
block <- new_write_block(
  directory = tempdir(),
  filename = "",
  format = "excel"
)

if (interactive()) {
  # Launch interactive app
  serve(new_write_block())
}

}
