% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ext-class.R
\name{new_dock_extension}
\alias{new_dock_extension}
\alias{is_dock_extension}
\alias{validate_extension}
\alias{extension_ui}
\alias{extension_server}
\alias{extension_id}
\alias{extension_name}
\alias{extension_ctor}
\alias{new_dock_extensions}
\alias{is_dock_extensions}
\alias{validate_extensions}
\alias{as_dock_extensions}
\alias{as_dock_extensions.dock_extensions}
\alias{as_dock_extensions.dock_extension}
\alias{as_dock_extensions.list}
\alias{extension_block_callback}
\title{Dock extensions}
\usage{
new_dock_extension(
  server,
  ui,
  name,
  class,
  ctor = sys.parent(),
  pkg = NULL,
  options = new_board_options(),
  ...
)

is_dock_extension(x)

validate_extension(x, ...)

extension_ui(x, id, ...)

extension_server(x, ...)

extension_id(x)

extension_name(x)

extension_ctor(x)

new_dock_extensions(x = list())

is_dock_extensions(x)

validate_extensions(x)

as_dock_extensions(x, ...)

\method{as_dock_extensions}{dock_extensions}(x, ...)

\method{as_dock_extensions}{dock_extension}(x, ...)

\method{as_dock_extensions}{list}(x, ...)

extension_block_callback(x, ...)
}
\arguments{
\item{server}{A function returning \code{\link[shiny:moduleServer]{shiny::moduleServer()}}}

\item{ui}{A function with a single argument (\code{ns}) returning a \code{shiny.tag}}

\item{name}{Name for extension}

\item{class}{Extension subclass}

\item{ctor}{Constructor function name}

\item{pkg}{Package to look up \code{ctor}}

\item{options}{Board options supplied by an extension}

\item{...}{Further attributes}

\item{x}{Extension object}

\item{id}{Namespace ID}
}
\value{
The constructors \code{new_dock_extension()} and \code{new_dock_extension()},
as do the coercion function \code{as_dock_extension()} and \code{as_dock_extension()},
return objects that inherit from \code{dock_extension} and \code{dock_extensions}
respectively. This inheritance structure can be checked using
\code{is_dock_extension()} and \code{is_dock_extensions()}, which both return a
boolean. A \code{dock_extension} can be validated using \code{validate_extension()}
and a \code{dock_extensions} object using \code{validate_extensions()}, which return
the input object invisibly and throw errors as side-effects. Several getter
functions return extension attributes, including \code{extension_ui()} (a
function), \code{extension_server()} (a function), \code{extension_id()} (a string),
\code{extension_name()} (a string) and \code{extension_ctor()} (an object that
inherits from \code{blockr_ctor}).
}
\description{
Functionality of a \code{dock_board} can be extended by supplying one or more
\code{dock_extension} objects, which essentially provide UI shown in a dock panel
that allows for manipulating the board state. A set of dock extensions
can be combined into a \code{dock_extensions} object.
}
\examples{
ext <- new_edit_board_extension()
is_dock_extension(ext)

}
