% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dock-board.R
\name{new_dock_board}
\alias{new_dock_board}
\alias{is_dock_board}
\alias{as_dock_board}
\alias{dock_layout}
\alias{dock_layout<-}
\alias{dock_extensions}
\alias{dock_extensions<-}
\alias{dock_ext_ids}
\alias{dock_board_options}
\title{Dock board}
\usage{
new_dock_board(
  blocks = list(),
  links = list(),
  stacks = list(),
  ...,
  extensions = new_dock_extensions(),
  layout = default_grid(blocks, extensions),
  options = dock_board_options(),
  ctor = NULL,
  pkg = NULL,
  class = character()
)

is_dock_board(x)

as_dock_board(x, ...)

dock_layout(x)

dock_layout(x) <- value

dock_extensions(x)

dock_extensions(x) <- value

dock_ext_ids(x)

dock_board_options()
}
\arguments{
\item{blocks}{Set of blocks}

\item{links}{Set of links}

\item{stacks}{Set of stacks}

\item{...}{Further (metadata) attributes}

\item{extensions}{Dock extensions}

\item{layout}{Dock layout}

\item{options}{Board-level user settings}

\item{ctor, pkg}{Constructor information (used for serialization)}

\item{class}{Board sub-class}

\item{x}{Board object}

\item{value}{Replacement value}
}
\value{
The constructor \code{new_dock_board()} returns a \code{board} object, as does
the coercion function \code{as_dock_board()}. Inheritance can be checked using
\code{is_dock_board()}, which returns a boolean. Getters \code{dock_layout()} and
\code{dock_extensions()} return \code{dock_layout} and \code{dock_extension} objects while
setters \verb{dock_layout<-()} and \verb{dock_extensions<-()} return the updated board
object (invisibly). A character vector of IDs is returned by \code{dock_ext_ids()}
and \code{dock_board_options()} returns a \code{board_options} object.
}
\description{
Using the docking layout manager provided by dockViewR, a \code{dock_board}
extends \code{\link[blockr.core:new_board]{blockr.core::new_board()}}. In addition to the attributes contained
in a core board, this also includes dock extensions (as \code{extensions})
and the panel arrangement (as \code{layout}).
}
\examples{
brd <- new_dock_board(c(a = blockr.core::new_dataset_block()))
str(dock_layout(brd), max.level = 2)

}
