% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/action-class.R, R/action-block.R,
%   R/action-link.R, R/action-stack.R, R/action-utils.R
\name{new_action}
\alias{new_action}
\alias{is_action}
\alias{is_action_module}
\alias{is_action_function}
\alias{add_block_action}
\alias{append_block_action}
\alias{remove_block_action}
\alias{add_link_action}
\alias{remove_link_action}
\alias{add_stack_action}
\alias{edit_stack_action}
\alias{remove_stack_action}
\alias{block_input_select}
\alias{block_registry_selectize}
\alias{board_select}
\title{Board actions}
\usage{
new_action(func)

is_action(x)

is_action_module(x)

is_action_function(x)

add_block_action(trigger, as_module = TRUE)

append_block_action(trigger, as_module = TRUE)

remove_block_action(trigger, as_module = TRUE)

add_link_action(trigger, as_module = TRUE)

remove_link_action(trigger, as_module = TRUE)

add_stack_action(trigger, as_module = TRUE)

edit_stack_action(trigger, as_module = TRUE)

remove_stack_action(trigger, as_module = TRUE)

block_input_select(
  block = NULL,
  block_id = NULL,
  links = NULL,
  mode = c("create", "update", "inputs"),
  ...
)

block_registry_selectize(id, blocks = list_blocks())

board_select(id, blocks, selected = NULL, ...)
}
\arguments{
\item{func}{A function which will be evaluated (with modified formals) in a
shiny server context}

\item{x}{Object}

\item{trigger}{A string, function or \code{\link[shiny:reactive]{shiny::reactive()}}}

\item{as_module}{Logical flag controlling the return type}

\item{block}{Block object}

\item{block_id}{Block ID}

\item{links}{Links object}

\item{mode}{Switch for determining the return object}

\item{...}{Forwarded to other methods}

\item{id}{Input ID}

\item{blocks}{Character vector of block registry IDs}

\item{selected}{Character vector of pre-selected block (registry) IDs}
}
\value{
The constructor \code{new_action} returns a classed function that
inherits from \code{action}. Inheritance can be checked with functions
\code{is_action()}, \code{is_action_module()} and \code{is_action_function()}, which all
return scalar logicals.

For utilities \code{block_input_select()}, \code{block_registry_selectize()}
and \code{board_select}, see the respective sections.
}
\description{
Logic including a modal-based UI for board actions such as "append block"
or "edit stack" can be specified using \code{action} objects, which essentially
are classed functions that can either be called to return a shiny module
\code{as_module = TRUE} or a function \code{as_module = FALSE} which injects code
(passed as \code{expr}) into a shiny server context.
}
\details{
An action is a function that can be called with arguments \code{trigger} and
\code{as_module} to return another function. The action trigger may either be a
string (referring to an \code{input}), a function (that will be called with a
single argument \code{input}) or a \code{\link[shiny:reactive]{shiny::reactive()}} object. The flag
\code{as_module} controls the behavior of the returned function: if \code{TRUE}, it
is a function (inheriting from \code{action_module}) with arguments \code{board},
\code{update}, \code{...} and \code{domain}, which, when called, again returns a function
with arguments \code{input}, \code{output} and \code{session}, suitable as argument to
\code{\link[shiny:moduleServer]{shiny::moduleServer()}}. If \code{FALSE} is passed instead, a function
(inheriting from \code{action_function}) with arguments \code{board}, \code{update}, \code{...}
and \code{domain} is returned.

The expression \code{expr}, passed when instantiating an \code{action} object will be
evaluated in a context, where the following bindings exist: \code{board},
\code{update}, \code{domain}, \code{input}, \code{output} and \code{session}. In the case of
\code{as_module = FALSE}, \code{domain} is an alias for \code{session}.
}
\section{\code{block_input_select()}}{

Determine input options for a block by removing inputs that are already used
and also takes into account some edge-cases, such as variadic blocks. If
\code{mode} is set as "inputs", this will return a character vector, for
"create", the return value of a \code{\link[shiny:selectInput]{shiny::selectizeInput()}} call and for
"update", the return value of a \code{\link[shiny:updateSelectInput]{shiny::updateSelectizeInput()}} call.
}

\section{\code{block_registry_selectize()}}{

This creates UI for a block registry selector via \code{\link[shiny:selectInput]{shiny::selectizeInput()}}
and returns an object that inherits from \code{shiny.tag}.
}

\section{\code{board_select()}}{

Block selection UI, enumerating all blocks in a board is available as
\code{board_select()}. An object that inherits from \code{shiny.tag} is returned, which
contains the result from a \code{\link[shiny:selectInput]{shiny::selectizeInput()}} call.
}

