% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_run.R
\name{plot_run}
\alias{plot_run}
\title{Plot Run Chart}
\usage{
plot_run(
  select_analyte,
  dat = bs_df,
  version = "original",
  log = "n",
  removal_notification = "n"
)
}
\arguments{
\item{select_analyte}{the selected analyte for this run chart}

\item{dat}{data frame with all data needed as described in `bs_prep_and_analysis`.
Default is `bs_df`.}

\item{version}{The run chart is either shown with `original` units, default,
or with the result shown as a `ratio` to the spike value.}

\item{log}{Set log = "y" to make the y-axis a log scale - original version
only. Default is "n".}

\item{removal_notification}{provide a list of results, by
 sample_ID that were removed from the current run plot because
 results were less than or equal to zero.

 @return run plot of laboratory analyses of spiked samples}
}
\description{
`plot_run()` produces a Run Chart of the selected analyte. The analyte
is selected from the analyte set provided. Results are plotted with error
bars (uncertainty with coverage factor of 2) when the result is greater than
the detection level. On the ratio version, the uncertainties for the results
and spike values are combined as the square root of the sums of the relative
uncertainties squared. When original results are plotted, the spike values
are shown with a small salmon-colored "+".
}
\examples{
example_spike_data <- system.file('extdata', 'spikevals.csv', package = 'blindspiker')
example_lab_data <- system.file('extdata', 'labvals.csv', package = 'blindspiker')
example_df <- bs_prep_and_analysis(spike_data = example_spike_data, lab_data = example_lab_data)
plot_run(select_analyte = 'unknownium', dat = example_df)

}
