% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rolling-oos.R
\name{rolling_oos}
\alias{rolling_oos}
\title{Rolling Out-of-Sample Forecast Evaluation}
\usage{
rolling_oos(
  best_fit,
  DT,
  h = 5,
  cuts = seq(round(0.6 * nrow(DT)), round(0.9 * nrow(DT)), length.out = 5)
)
}
\arguments{
\item{best_fit}{A fitted model object as returned by \code{fit_one()},
containing at least:
\itemize{
\item \code{$fit}: CmdStanR fit object with posterior draws.
\item \code{$des}: design matrices used by the model.
\item \code{$k}: lag order used in the fit.
}
This object is passed directly to \code{\link{predict_multistep}()}.}

\item{DT}{A \code{data.frame} or \code{data.table} containing the
original time series and covariates used to fit the model, including
at least columns \code{I} and \code{C}.}

\item{h}{Integer; maximum forecast horizon (number of steps ahead)
requested at each cut. For a given \code{Tcut}, the effective horizon
is \code{min(h, nrow(DT) - Tcut)}.}

\item{cuts}{Numeric vector of time indices (training end points) at
which to perform the rolling evaluation. By default, a grid of five
equally spaced cut points between 60\\% and 90\\% of the sample size is
used:
\code{seq(round(0.6 * nrow(DT)), round(0.9 * nrow(DT)), length.out = 5)}.}
}
\value{
A \code{data.frame} with one row per \code{Tcut} and columns:
\itemize{
\item \code{Tcut}: training end index.
\item \code{RMSE_I}: rolling OOS RMSE for series \code{I}.
\item \code{RMSE_C}: rolling OOS RMSE for series \code{C}.
}
}
\description{
Computes rolling out-of-sample (OOS) forecast accuracy for the
selected bivariate hurdle model by repeatedly truncating the sample
at different cut points \code{Tcut}, generating multi-step-ahead
predictive distributions, and summarizing them via RMSE for \code{I}
and \code{C}.
}
\details{
For each \code{Tcut} in \code{cuts}, the function:
\enumerate{
\item Calls \code{\link{predict_multistep}()} with
\code{fit_obj = best_fit}, the full \code{DT}, lag
\code{k = best_fit$k}, and horizon
\code{h_eff = min(h, nrow(DT) - Tcut)} to obtain posterior
predictive paths \code{pred_I} and \code{pred_C}.
\item Computes the posterior-mean forecast for each step
(\code{mI}, \code{mC}) as the column means of \code{pred_I}
and \code{pred_C}.
\item Extracts the realized outcomes
\code{yI = I[(Tcut + 1):(Tcut + h_eff)]} and analogously for
\code{yC}.
\item Computes RMSE for each series:
\code{RMSE_I = sqrt(mean((yI - mI)^2))},
\code{RMSE_C = sqrt(mean((yC - mC)^2))}.
}

Progress is reported via \pkg{progressr}. The resulting table is
written as \code{"rolling_oos.csv"} in the directory specified by a
global character scalar \code{dir_csv}.
}
\examples{
\donttest{
# Minimal synthetic example illustrating the expected data structure:
set.seed(123)
DT <- data.frame(
  id = rep(1:10, each = 2),
  t  = rep(1:2, times = 10),
  I  = rpois(20, lambda = 0.5),
  C  = rpois(20, lambda = 1.0)
)

# Directory for CSV output (in practice, use a persistent path chosen
# by the user):
dir_csv <- file.path(tempdir(), "bivarhr_oos_csv")

# Typical workflow (commented out to avoid heavy computation and
# external dependencies such as CmdStan during R CMD check):
#
# best_fit <- fit_one(
#   data = DT,
#   k    = 2,
#   spec = "C"
# )
#
# oos_res <- rolling_oos(
#   fit     = best_fit,
#   data    = DT,
#   h       = 6,
#   dir_csv = dir_csv
# )
# print(oos_res)
}

}
