% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_bioregion_pairwise.R
\name{as_bioregion_pairwise}
\alias{as_bioregion_pairwise}
\title{Convert a matrix or list of matrices to a bioregion (dis)similarity object}
\usage{
as_bioregion_pairwise(
  mat,
  metric_name = NULL,
  pkg = NULL,
  is_similarity = FALSE
)
}
\arguments{
\item{mat}{A \code{matrix}, a \code{dist} object, or a \code{list} of these representing
pairwise similarity or dissimilarity values to convert into a
\code{bioregion.pairwise} object. This function can also directly handle
outputs from other R packages (see the \code{pkg} argument).}

\item{metric_name}{Optional \code{character} vector or single \code{character} string
specifying the name of the (dis)similarity metric(s), which will appear as
column names in the output (see Note).}

\item{pkg}{An optional \code{character} string indicating the name of the package
from which \code{mat} was generated (\code{NULL} by default, see Details).
Available options are \code{"adespatial"}, \code{"betapart"}, \code{"ecodist"}, or
\code{"vegan"}.}

\item{is_similarity}{A \code{logical} value indicating whether the input data
represents similarity (\code{TRUE}) or dissimilarity (\code{FALSE}).}
}
\value{
A dissimilarity or similarity object of class \code{bioregion.pairwise},
compatible with the \code{bioregion} package.
}
\description{
Converts a (dis)similarity \code{matrix} or a \code{list} of such matrices into a
\code{bioregion.pairwise} object compatible with the \code{bioregion} package.
The input can come from base R, \code{dist} objects, or outputs from other
packages.
}
\details{
This function can directly handle outputs from ten functions across four
packages:
\itemize{
\item \strong{adespatial}: \link[adespatial:beta.div]{beta.div},
\link[adespatial:beta.div.comp]{beta.div.comp}
\item \strong{betapart}: \link[betapart:beta.pair]{beta.pair},
\link[betapart:beta.pair.abund]{beta.pair.abund},
\link[betapart:betapart.core]{betapart.core},
\link[betapart:betapart.core.abund]{betapart.core.abund}
\item \strong{ecodist}: \link[ecodist:distance]{distance},
\link[ecodist:bcdist]{bcdist}
\item \strong{vegan}: \link[vegan:vegdist]{vegdist},
\link[vegan:designdist]{designdist}
}

See the documentation of these packages for more information:
\itemize{
\item https://cran.r-project.org/package=adespatial
\item https://cran.r-project.org/package=betapart
\item https://cran.r-project.org/package=ecodist
\item https://cran.r-project.org/package=vegan
}
}
\note{
If no specific package is specified (i.e., \code{pkg = NULL}), site names will be
based on the row names of the first matrix. If row names are \code{NULL}, they
will be generated automatically. If \code{mat} is a named list, those names will
be used as column names only if \code{metric_name = NULL}.
}
\examples{

mat <- matrix(runif(100), 10, 10)
rownames(mat) <- paste0("s",1:10)

pair <- as_bioregion_pairwise(list(mat,mat,mat), 
                              metric_name = NULL,
                              pkg = NULL,
                              is_similarity = FALSE)
                              
pair

}
\seealso{
For more details illustrated with a practical example,
see the vignette:
\url{https://biorgeo.github.io/bioregion/articles/a3_pairwise_metrics.html}.

Associated functions:
\link{dissimilarity} \link{similarity} \link{bind_pairwise}
}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr}) \cr
Boris Leroy (\email{leroy.boris@gmail.com}) \cr
Pierre Denelle (\email{pierre.denelle@gmail.com})
}
