% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_SampleFactorLevels.R
\name{bm_SampleFactorLevels}
\alias{bm_SampleFactorLevels}
\alias{bm_SampleFactorLevels.raster}
\alias{bm_SampleFactorLevels.data.frame}
\title{Sample all levels of a factorial variable}
\usage{
bm_SampleFactorLevels(expl.var, mask.out = NULL, mask.in = NULL)
}
\arguments{
\item{expl.var}{a \code{data.frame} or \code{\link[terra:rast]{SpatRaster}}
object containing the explanatory variables (in columns or layers)}

\item{mask.out}{a \code{data.frame} or \code{\link[terra:rast]{SpatRaster}}
object containing the area that has already been sampled (\emph{factor 
levels within this mask will not be sampled})}

\item{mask.in}{a \code{data.frame} or \code{\link[terra:rast]{SpatRaster}} 
object containing areas where factor levels are to be sampled in priority. 
\emph{Note that if after having explored these masks, some factor levels 
remain unsampled, they will be sampled in the reference input object \code{expl.var}.}}
}
\value{
A \code{vector} of \code{numeric} values corresponding to either row (\code{data.frame}) or 
cell (\code{\link[terra:rast]{SpatRaster}}) numbers, each referring to a single level of a 
single factorial variable.

In case no factorial variable is found in the input object, \code{NULL} is returned.
}
\description{
This internal \pkg{biomod2} function allows the user to sample all levels of all 
the factorial variables contained in a \code{data.frame} or \code{\link[terra:rast]{SpatRaster}} 
object.
}
\details{
The \code{expl.var}, \code{mask.out} and \code{mask.in} parameters must be coherent in terms of 
dimensions :
\itemize{
  \item same number of rows for \code{data.frame} objects
  \item same resolution, projection system and number of cells for \code{\link[terra:rast]{SpatRaster}} objects 
  \cr \cr
}

If \code{mask.in} contains several columns (\code{data.frame}) or layers 
(\code{\link[terra:rast]{SpatRaster}}), then their order matters : 
they will be considered successively to sample missing factor levels. \cr \cr

\itemize{
  \item Values in \code{data.frame} will be understood as :
  \itemize{
    \item \code{FALSE} : out of mask
    \item \code{TRUE} : in mask
  }
  \item Values in \code{\link[terra:rast]{SpatRaster}} will be understood as :
  \itemize{
    \item \code{NA} : out of mask
    \item \code{not NA} : in mask
  }
}
}
\examples{
library(terra)

## Create raster data
ras.1 <- ras.2 <- mask.out <- rast(nrows = 10, ncols = 10)
ras.1[] <- as.factor(rep(c(1, 2, 3, 4, 5), each = 20))
ras.1 <- as.factor(ras.1)
ras.2[] <- rnorm(100)
stk <- c(ras.1, ras.2)
names(stk) <- c("varFact", "varNorm")

## define a mask for already sampled points
mask.out[1:40] <- 1

## define a list of masks where we want to sample in priority
mask.in <- list(ras.1, ras.1)
mask.in[[1]][1:80] <- NA ## only level 5 should be sampled in this mask
mask.in[[1]][21:80] <- NA ## only levels 1 and 5 should be sampled in this mask

## Sample all factor levels
samp1 <- bm_SampleFactorLevels(expl.var = stk, mask.out = mask.out)
samp2 <- bm_SampleFactorLevels(expl.var = stk, mask.in = mask.in)
samp3 <- bm_SampleFactorLevels(expl.var = stk, mask.out = mask.out, mask.in = mask.in)


}
\seealso{
\code{\link{bm_PseudoAbsences}}, \code{\link{bm_CrossValidation}}

Other Secondary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_CrossValidation}()},
\code{\link{bm_FindOptimStat}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_ModelAnalysis}()},
\code{\link{bm_ModelingOptions}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_PseudoAbsences}()},
\code{\link{bm_RangeSize}()},
\code{\link{bm_RunModelsLoop}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_Tuning}()},
\code{\link{bm_VariablesImportance}()}
}
\author{
Damien Georges
}
\concept{Secondary functions}
\keyword{factor}
\keyword{sample}
