% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_fit.R
\encoding{UTF-8}
\name{pls_fit}
\alias{pls_fit}
\title{Unified PLS fit with auto backend and selectable algorithm}
\usage{
pls_fit(
  X,
  y,
  ncomp,
  tol = 1e-08,
  backend = c("auto", "arma", "bigmem"),
  mode = c("auto", "pls1", "pls2"),
  algorithm = c("auto", "simpls", "nipals", "kernelpls", "widekernelpls", "rkhs",
    "klogitpls", "sparse_kpls", "rkhs_xy", "kf_pls"),
  scores = c("none", "r", "big"),
  chunk_size = 10000L,
  chunk_cols = NULL,
  scores_name = "scores",
  scores_target = c("auto", "new", "existing"),
  scores_bm = NULL,
  scores_backingfile = NULL,
  scores_backingpath = NULL,
  scores_descriptorfile = NULL,
  scores_colnames = NULL,
  return_scores_descriptor = FALSE,
  coef_threshold = NULL,
  kernel = c("linear", "rbf", "poly", "sigmoid"),
  gamma = 1,
  degree = 3L,
  coef0 = 0,
  approx = c("none", "nystrom", "rff"),
  approx_rank = NULL,
  class_weights = NULL
)
}
\arguments{
\item{X}{numeric matrix or \code{bigmemory::big.matrix}}

\item{y}{numeric vector/matrix or \code{big.matrix}}

\item{ncomp}{number of latent components}

\item{tol}{numeric tolerance used in the core solver}

\item{backend}{one of \code{"auto"}, \code{"arma"}, \code{"bigmem"}}

\item{mode}{one of \code{"auto"}, \code{"pls1"}, \code{"pls2"}}

\item{algorithm}{one of \code{"auto"}, \code{"simpls"}, \code{"nipals"},
\code{"kernelpls"}, \code{"widekernelpls"},
\code{"rkhs"}, \code{"klogitpls"}, \code{"sparse_kpls"},
\code{"rkhs_xy"}, \code{"kf_pls"}}

\item{scores}{one of \code{"none"}, \code{"r"}, \code{"big"}}

\item{chunk_size}{chunk size for the bigmem backend}

\item{chunk_cols}{columns chunk size for the bigmem backend}

\item{scores_name}{name for dense scores (or output big.matrix)}

\item{scores_target}{one of \code{"auto"}, \code{"new"}, \code{"existing"}}

\item{scores_bm}{optional existing big.matrix or descriptor for scores}

\item{scores_backingfile}{Character; file name for file-backed scores (when \code{scores="big"}).}

\item{scores_backingpath}{Character; directory for the file-backed scores.
Defaults to \code{getwd()} or \code{tempdir()} in streamed predict, unless overridden.}

\item{scores_descriptorfile}{Character; descriptor file name for the file-backed scores.}

\item{scores_colnames}{optional character vector for score column names}

\item{return_scores_descriptor}{logical; if TRUE and scores is big.matrix, add \code{$scores_descriptor}}

\item{coef_threshold}{Optional non-negative value used to hard-threshold
the fitted coefficients after model estimation. When supplied, absolute
coefficients strictly below the threshold are set to zero via
\code{\link[=pls_threshold]{pls_threshold()}}.}

\item{kernel}{kernel name for RKHS/KPLS (\code{"linear"}, \code{"rbf"}, \code{"poly"}, \code{"sigmoid"})}

\item{gamma}{RBF/sigmoid/poly scale parameter}

\item{degree}{polynomial degree}

\item{coef0}{polynomial/sigmoid bias}

\item{approx}{kernel approximation: \code{"none"}, \code{"nystrom"}, \code{"rff"}}

\item{approx_rank}{rank (columns / features) for the approximation}

\item{class_weights}{optional numeric weights for classes in \code{klogitpls}}
}
\value{
a list with coefficients, intercept, weights, loadings, means,
and optionally \code{$scores}.
}
\description{
Dispatches to a dense (Arm/BLAS) backend for in-memory matrices
or to a streaming big.matrix backend when X (or Y) is a big.matrix.
Algorithm can be chosen between:
"simpls" (default), "nipals", "kernelpls", "widekernelpls",
"rkhs" (Rosipal & Trejo), "klogitpls", "sparse_kpls",
"rkhs_xy" (double RKHS), and "kf_pls" (Kalman-filter PLS, streaming).

The "kernelpls" paths now include a streaming XX'
variant for big.matrix inputs, with an optional row-chunking loop
controlled by \code{chunk_cols}.
}
\examples{
set.seed(123)
X <- matrix(rnorm(60), nrow = 20)
y <- X[, 1] - 0.5 * X[, 2] + rnorm(20, sd = 0.1)
fit <- pls_fit(X, y, ncomp = 2, scores = "r", algorithm = "simpls")
head(pls_predict_response(fit, X, ncomp = 2))
}
