% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{model.matrix.brs}
\alias{model.matrix.brs}
\title{Extract design matrix}
\usage{
\method{model.matrix}{brs}(object, model = c("mean", "precision"), ...)
}
\arguments{
\item{object}{A fitted \code{"betaregscale"} object.}

\item{model}{Character: \code{"mean"} (default) or
\code{"precision"}.}

\item{...}{Ignored.}
}
\value{
The design matrix for the specified submodel.
}
\description{
Extract design matrix
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
head(model.matrix(fit))
head(model.matrix(fit, model = "precision"))
}

}
\seealso{
\code{\link{brs}}, \code{\link{formula.brs}},
  \code{\link{coef.brs}}
}
