% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brsmm-methods.R
\name{coef.brsmm}
\alias{coef.brsmm}
\title{Extract coefficients from a brsmm fit}
\usage{
\method{coef}{brsmm}(object, model = c("full", "mean", "precision", "random"), ...)
}
\arguments{
\item{object}{A fitted \code{"brsmm"} object.}

\item{model}{Character: \code{"full"} (default), \code{"mean"},
\code{"precision"}, or \code{"random"}.}

\item{...}{Currently ignored.}
}
\value{
Named numeric vector.
}
\description{
Extract coefficients from a brsmm fit
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  id = factor(rep(1:4, each = 5))
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brsmm(y ~ x1, random = ~ 1 | id, data = prep)
coef(fit)
coef(fit, model = "mean")
coef(fit, model = "random")
}

}
\seealso{
\code{\link{brsmm}}, \code{\link{vcov.brsmm}},
  \code{\link{confint.brsmm}}
}
