% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginaleffects.R
\name{brs_marginaleffects}
\alias{brs_marginaleffects}
\title{Marginal effects for brs models}
\usage{
brs_marginaleffects(
  object,
  newdata = NULL,
  model = c("mean", "precision"),
  type = c("response", "link"),
  variables = NULL,
  h = 1e-05,
  interval = TRUE,
  level = 0.95,
  n_sim = 400L,
  keep_draws = FALSE
)
}
\arguments{
\item{object}{A fitted \code{"brs"} object.}

\item{newdata}{Optional data frame for evaluation; defaults to the data
used in fitting.}

\item{model}{Character; \code{"mean"} (default) or \code{"precision"}.}

\item{type}{Character prediction scale:
\code{"response"} (default) or \code{"link"}.}

\item{variables}{Optional character vector of covariate names.
Defaults to all numeric covariates in the selected submodel.}

\item{h}{Finite-difference step for non-binary numeric covariates.}

\item{interval}{Logical; compute interval estimates via simulation.}

\item{level}{Confidence level for interval estimates.}

\item{n_sim}{Number of parameter draws when \code{interval = TRUE}.}

\item{keep_draws}{Logical; if \code{TRUE} and \code{interval = TRUE},
stores AME simulation draws in attribute \code{"ame_draws"}.}
}
\value{
A data frame with one row per variable and columns:
  \code{variable}, \code{ame}, \code{std.error}, \code{ci.lower},
  \code{ci.upper}, \code{model}, \code{type}, and \code{n}.
  The returned object has class \code{"brs_marginaleffects"} and
  attributes with analysis metadata.
}
\description{
Computes average marginal effects (AME) for numeric covariates in the
mean or precision submodel of a fitted \code{"brs"} object.
}
\details{
AMEs are computed by finite differences on predictions:
\deqn{
\mathrm{AME}_j = \frac{1}{n}\sum_{i=1}^{n}
\frac{\hat{g}_i(x_{ij} + h) - \hat{g}_i(x_{ij})}{h},
}
where \eqn{\hat{g}_i} is the selected prediction scale.

For binary covariates coded as \code{0/1}, the effect is computed as the
average discrete difference \eqn{\hat{g}(x_j=1)-\hat{g}(x_j=0)}.

If \code{interval = TRUE}, uncertainty is approximated by asymptotic
parameter simulation from \eqn{\mathcal{N}(\hat{\theta}, \hat{V})}.
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  x2 = rep(c(0, 0, 1, 1), 5)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
brs_marginaleffects(fit, model = "mean", type = "response")
}

}
\references{
Lopes, J. E. (2023). \emph{Modelos de regressao beta para dados de escala}.
Master's dissertation, Universidade Federal do Parana, Curitiba.
URI: \url{https://hdl.handle.net/1884/86624}.

Hawker, G. A., Mian, S., Kendzerska, T., and French, M. (2011).
Measures of adult pain: Visual Analog Scale for Pain (VAS Pain),
Numeric Rating Scale for Pain (NRS Pain), McGill Pain Questionnaire (MPQ),
Short-Form McGill Pain Questionnaire (SF-MPQ), Chronic Pain Grade Scale
(CPGS), Short Form-36 Bodily Pain Scale (SF-36 BPS), and Measure of
Intermittent and Constant Osteoarthritis Pain (ICOAP).
Arthritis Care and Research, 63(S11), S240-S252.
\doi{10.1002/acr.20543}

Hjermstad, M. J., Fayers, P. M., Haugen, D. F., et al. (2011).
Studies comparing Numerical Rating Scales, Verbal Rating Scales, and
Visual Analogue Scales for assessment of pain intensity in adults:
a systematic literature review.
Journal of Pain and Symptom Management, 41(6), 1073-1093.
\doi{10.1016/j.jpainsymman.2010.08.016}
}
