% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brsmm-methods.R
\name{BIC.brsmm}
\alias{BIC.brsmm}
\title{BIC for brsmm models}
\usage{
\method{BIC}{brsmm}(object, ...)
}
\arguments{
\item{object}{A fitted \code{"brsmm"} object.}

\item{...}{Currently ignored.}
}
\value{
Numeric scalar.
}
\description{
BIC for brsmm models
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  id = factor(rep(1:4, each = 5))
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brsmm(y ~ x1, random = ~ 1 | id, data = prep)
BIC(fit)
}

}
\seealso{
\code{\link{brsmm}}, \code{\link{logLik.brsmm}},
  \code{\link{AIC.brsmm}}, \code{\link{brs_gof}}
}
