% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_ref}
\alias{read_ref}
\alias{validate_ref}
\title{Read and Validate Habitat References Files}
\usage{
read_ref(filename, indicators = c("S", "H", "AMBI"))

validate_ref(x, indicators = c("S", "H", "AMBI"))
}
\arguments{
\item{filename}{name of the habitat reference file (\code{character})}

\item{indicators}{indicators to be processed (\code{character},
see details)}

\item{x}{table in REF-format}
}
\description{
This function reads and checks files with reference values
}
\details{
The function performs the following tasks:
\itemize{
		\item{checks the existence of \code{filename};}
 	\item{checks availablitity of required columns (case insensitive);}
 	\item{removes redundant spaces}
 	\item{removes duplicated records}
 }

Argument \code{indicators} is a \code{character} vector of additional benthic
indicators to be checked for. For example, if \code{indicators = "ITI"}, then
the habitat reference file should also contain columns ITIREF and ITIBAD.
Implemented indicators are N, LNN, S, D, SN, SNA, H, L, AMBI, ITI, PIE, N2
(see package vignette).

The format of the habitat reference file is documented in the
BEQI2-package vignette.
}
\section{Functions}{
\itemize{
\item \code{validate_ref()}: validator for REF-format

}}
\references{
Van Loon, W, 2013. Loon2013-BEQI2-Specs-Ecotopes-27nov.doc
}
