% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp-methods.R
\name{tidy.cp_model_nls}
\alias{tidy.cp_model_nls}
\title{Convert a cross-price model to a tidy data frame of coefficients}
\usage{
\method{tidy}{cp_model_nls}(x, ...)
}
\arguments{
\item{x}{A model object from fit_cp_nls or fit_cp_linear}

\item{...}{Additional arguments (unused)}
}
\value{
A data frame with one row per coefficient, containing columns:
\item{term}{The name of the model parameter}
\item{estimate}{The estimated coefficient value}
\item{std.error}{The standard error of the coefficient}
\item{statistic}{The t-statistic for the coefficient}
\item{p.value}{The p-value for the coefficient}
}
\description{
This function extracts model coefficients from a cross-price demand model
into a tidy data frame format, following the conventions of the broom package.
It handles cases where model fitting failed gracefully, returning an empty
data frame with the expected structure.
}
\examples{
\donttest{
data(etm)
fit <- fit_cp_nls(etm, equation = "exponentiated")
tidy(fit)
}

}
