% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/systematic-methods.R
\name{summary.cp_unsystematic}
\alias{summary.cp_unsystematic}
\title{Summarize Cross-Price Unsystematic Data Check Results}
\usage{
\method{summary}{cp_unsystematic}(object, ...)
}
\arguments{
\item{object}{A data frame containing results from multiple \code{check_unsystematic_cp()} calls,
with at minimum the columns 'delta_direction', 'bounce_direction', and 'bounce_any'.
Columns 'id', 'group', 'reversals', and 'returns' are optional but allow extended summaries.}

\item{...}{Additional arguments (currently unused)}
}
\value{
A list of class \code{summary.cp_unsystematic} with the following elements:
\describe{
\item{total_patterns}{Number of total patterns examined.}
\item{systematic_count}{Count of systematic patterns (no bounce).}
\item{unsystematic_count}{Count of unsystematic patterns (bounce detected).}
\item{systematic_percent}{Proportion of systematic patterns.}
\item{unsystematic_percent}{Proportion of unsystematic patterns.}
\item{trend_counts}{Breakdown of trend directions.}
\item{bounce_counts}{Breakdown of bounce directions.}
\item{reversal_summary}{(Optional) Summary of zero-reversal patterns, if present in input.}
\item{return_summary}{(Optional) Summary of zero-return patterns, if present in input.}
\item{group_summary}{(Optional) Summary stats by 'group'.}
\item{problem_ids}{(Optional) Top IDs with unsystematic patterns.}
}
}
\description{
Summarizes systematic and unsystematic patterns from multiple calls to
\code{check_unsystematic_cp()}. This includes overall proportions, trend and bounce
direction counts, and optionally summaries by subject or group.
}
